// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> Feature Validation Response. </summary>
    public partial class BackupFeatureValidationResult : BackupFeatureValidationResultBase
    {
        /// <summary> Initializes a new instance of <see cref="BackupFeatureValidationResult"/>. </summary>
        internal BackupFeatureValidationResult()
        {
            Features = new ChangeTrackingList<BackupSupportedFeature>();
            ObjectType = "FeatureValidationResponse";
        }

        /// <summary> Initializes a new instance of <see cref="BackupFeatureValidationResult"/>. </summary>
        /// <param name="objectType"> Type of the specific object - used for deserializing. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="featureType"> backup support feature type. </param>
        /// <param name="features"> Response features. </param>
        internal BackupFeatureValidationResult(string objectType, IDictionary<string, BinaryData> serializedAdditionalRawData, BackupSupportedFeatureType? featureType, IReadOnlyList<BackupSupportedFeature> features) : base(objectType, serializedAdditionalRawData)
        {
            FeatureType = featureType;
            Features = features;
            ObjectType = objectType ?? "FeatureValidationResponse";
        }

        /// <summary> backup support feature type. </summary>
        public BackupSupportedFeatureType? FeatureType { get; }
        /// <summary> Response features. </summary>
        public IReadOnlyList<BackupSupportedFeature> Features { get; }
    }
}
