// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> The BackupAbsoluteMarker. </summary>
    public readonly partial struct BackupAbsoluteMarker : IEquatable<BackupAbsoluteMarker>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BackupAbsoluteMarker"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BackupAbsoluteMarker(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AllBackupValue = "AllBackup";
        private const string FirstOfDayValue = "FirstOfDay";
        private const string FirstOfMonthValue = "FirstOfMonth";
        private const string FirstOfWeekValue = "FirstOfWeek";
        private const string FirstOfYearValue = "FirstOfYear";

        /// <summary> AllBackup. </summary>
        public static BackupAbsoluteMarker AllBackup { get; } = new BackupAbsoluteMarker(AllBackupValue);
        /// <summary> FirstOfDay. </summary>
        public static BackupAbsoluteMarker FirstOfDay { get; } = new BackupAbsoluteMarker(FirstOfDayValue);
        /// <summary> FirstOfMonth. </summary>
        public static BackupAbsoluteMarker FirstOfMonth { get; } = new BackupAbsoluteMarker(FirstOfMonthValue);
        /// <summary> FirstOfWeek. </summary>
        public static BackupAbsoluteMarker FirstOfWeek { get; } = new BackupAbsoluteMarker(FirstOfWeekValue);
        /// <summary> FirstOfYear. </summary>
        public static BackupAbsoluteMarker FirstOfYear { get; } = new BackupAbsoluteMarker(FirstOfYearValue);
        /// <summary> Determines if two <see cref="BackupAbsoluteMarker"/> values are the same. </summary>
        public static bool operator ==(BackupAbsoluteMarker left, BackupAbsoluteMarker right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BackupAbsoluteMarker"/> values are not the same. </summary>
        public static bool operator !=(BackupAbsoluteMarker left, BackupAbsoluteMarker right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BackupAbsoluteMarker"/>. </summary>
        public static implicit operator BackupAbsoluteMarker(string value) => new BackupAbsoluteMarker(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BackupAbsoluteMarker other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BackupAbsoluteMarker other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
