// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> The AzureMonitorAlertsState. </summary>
    public readonly partial struct AzureMonitorAlertsState : IEquatable<AzureMonitorAlertsState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AzureMonitorAlertsState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AzureMonitorAlertsState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static AzureMonitorAlertsState Enabled { get; } = new AzureMonitorAlertsState(EnabledValue);
        /// <summary> Disabled. </summary>
        public static AzureMonitorAlertsState Disabled { get; } = new AzureMonitorAlertsState(DisabledValue);
        /// <summary> Determines if two <see cref="AzureMonitorAlertsState"/> values are the same. </summary>
        public static bool operator ==(AzureMonitorAlertsState left, AzureMonitorAlertsState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AzureMonitorAlertsState"/> values are not the same. </summary>
        public static bool operator !=(AzureMonitorAlertsState left, AzureMonitorAlertsState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AzureMonitorAlertsState"/>. </summary>
        public static implicit operator AzureMonitorAlertsState(string value) => new AzureMonitorAlertsState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AzureMonitorAlertsState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AzureMonitorAlertsState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
