// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> Adhoc trigger context. </summary>
    public partial class AdhocBasedBackupTriggerContext : DataProtectionBackupTriggerContext
    {
        /// <summary> Initializes a new instance of <see cref="AdhocBasedBackupTriggerContext"/>. </summary>
        /// <param name="objectType"> Type of the specific object - used for deserializing. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="adhocBackupRetention"> Tagging Criteria containing retention tag for adhoc backup. </param>
        internal AdhocBasedBackupTriggerContext(string objectType, IDictionary<string, BinaryData> serializedAdditionalRawData, AdhocBasedBackupTaggingCriteria adhocBackupRetention) : base(objectType, serializedAdditionalRawData)
        {
            AdhocBackupRetention = adhocBackupRetention;
            ObjectType = objectType ?? "AdhocBasedTriggerContext";
        }

        /// <summary> Initializes a new instance of <see cref="AdhocBasedBackupTriggerContext"/> for deserialization. </summary>
        internal AdhocBasedBackupTriggerContext()
        {
        }

        /// <summary> Tagging Criteria containing retention tag for adhoc backup. </summary>
        internal AdhocBasedBackupTaggingCriteria AdhocBackupRetention { get; set; }
        /// <summary> Retention tag information. </summary>
        public DataProtectionBackupRetentionTag AdhocBackupRetentionTagInfo
        {
            get => AdhocBackupRetention is null ? default : AdhocBackupRetention.TagInfo;
            set
            {
                if (AdhocBackupRetention is null)
                    AdhocBackupRetention = new AdhocBasedBackupTaggingCriteria();
                AdhocBackupRetention.TagInfo = value;
            }
        }
    }
}
