// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> Adhoc backup tagging criteria. </summary>
    internal partial class AdhocBasedBackupTaggingCriteria
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AdhocBasedBackupTaggingCriteria"/>. </summary>
        public AdhocBasedBackupTaggingCriteria()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AdhocBasedBackupTaggingCriteria"/>. </summary>
        /// <param name="tagInfo"> Retention tag information. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AdhocBasedBackupTaggingCriteria(DataProtectionBackupRetentionTag tagInfo, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TagInfo = tagInfo;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Retention tag information. </summary>
        public DataProtectionBackupRetentionTag TagInfo { get; set; }
    }
}
