// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataProtectionBackup.Models
{
    /// <summary> Validate for backup request. </summary>
    public partial class AdhocBackupValidateContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AdhocBackupValidateContent"/>. </summary>
        /// <param name="backupInstance"> Backup Instance. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="backupInstance"/> is null. </exception>
        public AdhocBackupValidateContent(DataProtectionBackupInstanceProperties backupInstance)
        {
            Argument.AssertNotNull(backupInstance, nameof(backupInstance));

            BackupInstance = backupInstance;
        }

        /// <summary> Initializes a new instance of <see cref="AdhocBackupValidateContent"/>. </summary>
        /// <param name="backupInstance"> Backup Instance. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AdhocBackupValidateContent(DataProtectionBackupInstanceProperties backupInstance, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            BackupInstance = backupInstance;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AdhocBackupValidateContent"/> for deserialization. </summary>
        internal AdhocBackupValidateContent()
        {
        }

        /// <summary> Backup Instance. </summary>
        public DataProtectionBackupInstanceProperties BackupInstance { get; }
    }
}
