// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DataProtectionBackup
{
    internal class DataProtectionBackupVaultOperationSource : IOperationSource<DataProtectionBackupVaultResource>
    {
        private readonly ArmClient _client;

        internal DataProtectionBackupVaultOperationSource(ArmClient client)
        {
            _client = client;
        }

        DataProtectionBackupVaultResource IOperationSource<DataProtectionBackupVaultResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DataProtectionBackupVaultData.DeserializeDataProtectionBackupVaultData(document.RootElement);
            return new DataProtectionBackupVaultResource(_client, data);
        }

        async ValueTask<DataProtectionBackupVaultResource> IOperationSource<DataProtectionBackupVaultResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DataProtectionBackupVaultData.DeserializeDataProtectionBackupVaultData(document.RootElement);
            return new DataProtectionBackupVaultResource(_client, data);
        }
    }
}
