// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DataProtectionBackup
{
    internal class DataProtectionBackupInstanceOperationSource : IOperationSource<DataProtectionBackupInstanceResource>
    {
        private readonly ArmClient _client;

        internal DataProtectionBackupInstanceOperationSource(ArmClient client)
        {
            _client = client;
        }

        DataProtectionBackupInstanceResource IOperationSource<DataProtectionBackupInstanceResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DataProtectionBackupInstanceData.DeserializeDataProtectionBackupInstanceData(document.RootElement);
            return new DataProtectionBackupInstanceResource(_client, data);
        }

        async ValueTask<DataProtectionBackupInstanceResource> IOperationSource<DataProtectionBackupInstanceResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DataProtectionBackupInstanceData.DeserializeDataProtectionBackupInstanceData(document.RootElement);
            return new DataProtectionBackupInstanceResource(_client, data);
        }
    }
}
