// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.DataProtectionBackup.Models;

namespace Azure.ResourceManager.DataProtectionBackup.Mocking
{
    /// <summary> A class to add extension methods to ResourceGroupResource. </summary>
    public partial class MockableDataProtectionBackupResourceGroupResource : ArmResource
    {
        private ClientDiagnostics _dataProtectionBackupVaultBackupVaultsClientDiagnostics;
        private BackupVaultsRestOperations _dataProtectionBackupVaultBackupVaultsRestClient;
        private ClientDiagnostics _dataProtectionBackupInstanceBackupInstancesClientDiagnostics;
        private BackupInstancesRestOperations _dataProtectionBackupInstanceBackupInstancesRestClient;
        private ClientDiagnostics _fetchSecondaryRecoveryPointsClientDiagnostics;
        private FetchSecondaryRecoveryPointsRestOperations _fetchSecondaryRecoveryPointsRestClient;
        private ClientDiagnostics _fetchCrossRegionRestoreJobClientDiagnostics;
        private FetchCrossRegionRestoreJobRestOperations _fetchCrossRegionRestoreJobRestClient;
        private ClientDiagnostics _fetchCrossRegionRestoreJobsClientDiagnostics;
        private FetchCrossRegionRestoreJobsRestOperations _fetchCrossRegionRestoreJobsRestClient;

        /// <summary> Initializes a new instance of the <see cref="MockableDataProtectionBackupResourceGroupResource"/> class for mocking. </summary>
        protected MockableDataProtectionBackupResourceGroupResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableDataProtectionBackupResourceGroupResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableDataProtectionBackupResourceGroupResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private ClientDiagnostics DataProtectionBackupVaultBackupVaultsClientDiagnostics => _dataProtectionBackupVaultBackupVaultsClientDiagnostics ??= new ClientDiagnostics("Azure.ResourceManager.DataProtectionBackup", DataProtectionBackupVaultResource.ResourceType.Namespace, Diagnostics);
        private BackupVaultsRestOperations DataProtectionBackupVaultBackupVaultsRestClient => _dataProtectionBackupVaultBackupVaultsRestClient ??= new BackupVaultsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, GetApiVersionOrNull(DataProtectionBackupVaultResource.ResourceType));
        private ClientDiagnostics DataProtectionBackupInstanceBackupInstancesClientDiagnostics => _dataProtectionBackupInstanceBackupInstancesClientDiagnostics ??= new ClientDiagnostics("Azure.ResourceManager.DataProtectionBackup", DataProtectionBackupInstanceResource.ResourceType.Namespace, Diagnostics);
        private BackupInstancesRestOperations DataProtectionBackupInstanceBackupInstancesRestClient => _dataProtectionBackupInstanceBackupInstancesRestClient ??= new BackupInstancesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, GetApiVersionOrNull(DataProtectionBackupInstanceResource.ResourceType));
        private ClientDiagnostics FetchSecondaryRecoveryPointsClientDiagnostics => _fetchSecondaryRecoveryPointsClientDiagnostics ??= new ClientDiagnostics("Azure.ResourceManager.DataProtectionBackup", ProviderConstants.DefaultProviderNamespace, Diagnostics);
        private FetchSecondaryRecoveryPointsRestOperations FetchSecondaryRecoveryPointsRestClient => _fetchSecondaryRecoveryPointsRestClient ??= new FetchSecondaryRecoveryPointsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);
        private ClientDiagnostics FetchCrossRegionRestoreJobClientDiagnostics => _fetchCrossRegionRestoreJobClientDiagnostics ??= new ClientDiagnostics("Azure.ResourceManager.DataProtectionBackup", ProviderConstants.DefaultProviderNamespace, Diagnostics);
        private FetchCrossRegionRestoreJobRestOperations FetchCrossRegionRestoreJobRestClient => _fetchCrossRegionRestoreJobRestClient ??= new FetchCrossRegionRestoreJobRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);
        private ClientDiagnostics FetchCrossRegionRestoreJobsClientDiagnostics => _fetchCrossRegionRestoreJobsClientDiagnostics ??= new ClientDiagnostics("Azure.ResourceManager.DataProtectionBackup", ProviderConstants.DefaultProviderNamespace, Diagnostics);
        private FetchCrossRegionRestoreJobsRestOperations FetchCrossRegionRestoreJobsRestClient => _fetchCrossRegionRestoreJobsRestClient ??= new FetchCrossRegionRestoreJobsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary> Gets a collection of DataProtectionBackupVaultResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of DataProtectionBackupVaultResources and their operations over a DataProtectionBackupVaultResource. </returns>
        public virtual DataProtectionBackupVaultCollection GetDataProtectionBackupVaults()
        {
            return GetCachedClient(client => new DataProtectionBackupVaultCollection(client, Id));
        }

        /// <summary>
        /// Returns a resource belonging to a resource group.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/backupVaults/{vaultName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BackupVaults_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataProtectionBackupVaultResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="vaultName"> The name of the backup vault. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="vaultName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="vaultName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<DataProtectionBackupVaultResource>> GetDataProtectionBackupVaultAsync(string vaultName, CancellationToken cancellationToken = default)
        {
            return await GetDataProtectionBackupVaults().GetAsync(vaultName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Returns a resource belonging to a resource group.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/backupVaults/{vaultName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BackupVaults_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataProtectionBackupVaultResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="vaultName"> The name of the backup vault. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="vaultName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="vaultName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<DataProtectionBackupVaultResource> GetDataProtectionBackupVault(string vaultName, CancellationToken cancellationToken = default)
        {
            return GetDataProtectionBackupVaults().Get(vaultName, cancellationToken);
        }

        /// <summary> Gets a collection of ResourceGuardResources in the ResourceGroupResource. </summary>
        /// <returns> An object representing collection of ResourceGuardResources and their operations over a ResourceGuardResource. </returns>
        public virtual ResourceGuardCollection GetResourceGuards()
        {
            return GetCachedClient(client => new ResourceGuardCollection(client, Id));
        }

        /// <summary>
        /// Returns a ResourceGuard belonging to a resource group.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ResourceGuards_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ResourceGuardResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="resourceGuardsName"> The name of ResourceGuard. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceGuardsName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="resourceGuardsName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<ResourceGuardResource>> GetResourceGuardAsync(string resourceGuardsName, CancellationToken cancellationToken = default)
        {
            return await GetResourceGuards().GetAsync(resourceGuardsName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Returns a ResourceGuard belonging to a resource group.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ResourceGuards_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="ResourceGuardResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="resourceGuardsName"> The name of ResourceGuard. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceGuardsName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="resourceGuardsName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<ResourceGuardResource> GetResourceGuard(string resourceGuardsName, CancellationToken cancellationToken = default)
        {
            return GetResourceGuards().Get(resourceGuardsName, cancellationToken);
        }

        /// <summary>
        /// API to check for resource name availability
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/locations/{location}/checkNameAvailability</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BackupVaults_CheckNameAvailability</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataProtectionBackupVaultResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="location"> The location in which uniqueness will be verified. </param>
        /// <param name="content"> Check name availability request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        public virtual async Task<Response<DataProtectionBackupNameAvailabilityResult>> CheckDataProtectionBackupVaultNameAvailabilityAsync(AzureLocation location, DataProtectionBackupNameAvailabilityContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = DataProtectionBackupVaultBackupVaultsClientDiagnostics.CreateScope("MockableDataProtectionBackupResourceGroupResource.CheckDataProtectionBackupVaultNameAvailability");
            scope.Start();
            try
            {
                var response = await DataProtectionBackupVaultBackupVaultsRestClient.CheckNameAvailabilityAsync(Id.SubscriptionId, Id.ResourceGroupName, location, content, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// API to check for resource name availability
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/locations/{location}/checkNameAvailability</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BackupVaults_CheckNameAvailability</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataProtectionBackupVaultResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="location"> The location in which uniqueness will be verified. </param>
        /// <param name="content"> Check name availability request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        public virtual Response<DataProtectionBackupNameAvailabilityResult> CheckDataProtectionBackupVaultNameAvailability(AzureLocation location, DataProtectionBackupNameAvailabilityContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = DataProtectionBackupVaultBackupVaultsClientDiagnostics.CreateScope("MockableDataProtectionBackupResourceGroupResource.CheckDataProtectionBackupVaultNameAvailability");
            scope.Start();
            try
            {
                var response = DataProtectionBackupVaultBackupVaultsRestClient.CheckNameAvailability(Id.SubscriptionId, Id.ResourceGroupName, location, content, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Triggers Cross Region Restore for BackupInstance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/locations/{location}/crossRegionRestore</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BackupInstances_TriggerCrossRegionRestore</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataProtectionBackupInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="location"> The name of the Azure region. </param>
        /// <param name="crossRegionRestoreRequestObject"> Request body for trigger CRR operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="crossRegionRestoreRequestObject"/> is null. </exception>
        public virtual async Task<ArmOperation<DataProtectionOperationJobExtendedInfo>> TriggerCrossRegionRestoreBackupInstanceAsync(WaitUntil waitUntil, AzureLocation location, CrossRegionRestoreRequestObject crossRegionRestoreRequestObject, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(crossRegionRestoreRequestObject, nameof(crossRegionRestoreRequestObject));

            using var scope = DataProtectionBackupInstanceBackupInstancesClientDiagnostics.CreateScope("MockableDataProtectionBackupResourceGroupResource.TriggerCrossRegionRestoreBackupInstance");
            scope.Start();
            try
            {
                var response = await DataProtectionBackupInstanceBackupInstancesRestClient.TriggerCrossRegionRestoreAsync(Id.SubscriptionId, Id.ResourceGroupName, location, crossRegionRestoreRequestObject, cancellationToken).ConfigureAwait(false);
                var operation = new DataProtectionBackupArmOperation<DataProtectionOperationJobExtendedInfo>(new DataProtectionOperationJobExtendedInfoOperationSource(), DataProtectionBackupInstanceBackupInstancesClientDiagnostics, Pipeline, DataProtectionBackupInstanceBackupInstancesRestClient.CreateTriggerCrossRegionRestoreRequest(Id.SubscriptionId, Id.ResourceGroupName, location, crossRegionRestoreRequestObject).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Triggers Cross Region Restore for BackupInstance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/locations/{location}/crossRegionRestore</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BackupInstances_TriggerCrossRegionRestore</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataProtectionBackupInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="location"> The name of the Azure region. </param>
        /// <param name="crossRegionRestoreRequestObject"> Request body for trigger CRR operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="crossRegionRestoreRequestObject"/> is null. </exception>
        public virtual ArmOperation<DataProtectionOperationJobExtendedInfo> TriggerCrossRegionRestoreBackupInstance(WaitUntil waitUntil, AzureLocation location, CrossRegionRestoreRequestObject crossRegionRestoreRequestObject, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(crossRegionRestoreRequestObject, nameof(crossRegionRestoreRequestObject));

            using var scope = DataProtectionBackupInstanceBackupInstancesClientDiagnostics.CreateScope("MockableDataProtectionBackupResourceGroupResource.TriggerCrossRegionRestoreBackupInstance");
            scope.Start();
            try
            {
                var response = DataProtectionBackupInstanceBackupInstancesRestClient.TriggerCrossRegionRestore(Id.SubscriptionId, Id.ResourceGroupName, location, crossRegionRestoreRequestObject, cancellationToken);
                var operation = new DataProtectionBackupArmOperation<DataProtectionOperationJobExtendedInfo>(new DataProtectionOperationJobExtendedInfoOperationSource(), DataProtectionBackupInstanceBackupInstancesClientDiagnostics, Pipeline, DataProtectionBackupInstanceBackupInstancesRestClient.CreateTriggerCrossRegionRestoreRequest(Id.SubscriptionId, Id.ResourceGroupName, location, crossRegionRestoreRequestObject).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Validates whether Cross Region Restore can be triggered for DataSource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/locations/{location}/validateCrossRegionRestore</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BackupInstances_ValidateCrossRegionRestore</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataProtectionBackupInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="location"> The name of the Azure region. </param>
        /// <param name="validateCrossRegionRestoreRequestObject"> Request body for operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="validateCrossRegionRestoreRequestObject"/> is null. </exception>
        public virtual async Task<ArmOperation<DataProtectionOperationJobExtendedInfo>> ValidateCrossRegionRestoreBackupInstanceAsync(WaitUntil waitUntil, AzureLocation location, ValidateCrossRegionRestoreRequestObject validateCrossRegionRestoreRequestObject, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(validateCrossRegionRestoreRequestObject, nameof(validateCrossRegionRestoreRequestObject));

            using var scope = DataProtectionBackupInstanceBackupInstancesClientDiagnostics.CreateScope("MockableDataProtectionBackupResourceGroupResource.ValidateCrossRegionRestoreBackupInstance");
            scope.Start();
            try
            {
                var response = await DataProtectionBackupInstanceBackupInstancesRestClient.ValidateCrossRegionRestoreAsync(Id.SubscriptionId, Id.ResourceGroupName, location, validateCrossRegionRestoreRequestObject, cancellationToken).ConfigureAwait(false);
                var operation = new DataProtectionBackupArmOperation<DataProtectionOperationJobExtendedInfo>(new DataProtectionOperationJobExtendedInfoOperationSource(), DataProtectionBackupInstanceBackupInstancesClientDiagnostics, Pipeline, DataProtectionBackupInstanceBackupInstancesRestClient.CreateValidateCrossRegionRestoreRequest(Id.SubscriptionId, Id.ResourceGroupName, location, validateCrossRegionRestoreRequestObject).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Validates whether Cross Region Restore can be triggered for DataSource.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/locations/{location}/validateCrossRegionRestore</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BackupInstances_ValidateCrossRegionRestore</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="DataProtectionBackupInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="location"> The name of the Azure region. </param>
        /// <param name="validateCrossRegionRestoreRequestObject"> Request body for operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="validateCrossRegionRestoreRequestObject"/> is null. </exception>
        public virtual ArmOperation<DataProtectionOperationJobExtendedInfo> ValidateCrossRegionRestoreBackupInstance(WaitUntil waitUntil, AzureLocation location, ValidateCrossRegionRestoreRequestObject validateCrossRegionRestoreRequestObject, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(validateCrossRegionRestoreRequestObject, nameof(validateCrossRegionRestoreRequestObject));

            using var scope = DataProtectionBackupInstanceBackupInstancesClientDiagnostics.CreateScope("MockableDataProtectionBackupResourceGroupResource.ValidateCrossRegionRestoreBackupInstance");
            scope.Start();
            try
            {
                var response = DataProtectionBackupInstanceBackupInstancesRestClient.ValidateCrossRegionRestore(Id.SubscriptionId, Id.ResourceGroupName, location, validateCrossRegionRestoreRequestObject, cancellationToken);
                var operation = new DataProtectionBackupArmOperation<DataProtectionOperationJobExtendedInfo>(new DataProtectionOperationJobExtendedInfoOperationSource(), DataProtectionBackupInstanceBackupInstancesClientDiagnostics, Pipeline, DataProtectionBackupInstanceBackupInstancesRestClient.CreateValidateCrossRegionRestoreRequest(Id.SubscriptionId, Id.ResourceGroupName, location, validateCrossRegionRestoreRequestObject).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Returns a list of Secondary Recovery Points for a DataSource in a vault, that can be used for Cross Region Restore.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/locations/{location}/fetchSecondaryRecoveryPoints</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>FetchSecondaryRecoveryPoints_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="location"> The name of the Azure region. </param>
        /// <param name="content"> Request body for operation. </param>
        /// <param name="filter"> OData filter options. </param>
        /// <param name="skipToken"> skipToken Filter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <returns> An async collection of <see cref="DataProtectionBackupRecoveryPointResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<DataProtectionBackupRecoveryPointResource> GetSecondaryRecoveryPointsAsync(AzureLocation location, FetchSecondaryRPsRequestContent content, string filter = null, string skipToken = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            HttpMessage FirstPageRequest(int? pageSizeHint) => FetchSecondaryRecoveryPointsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, location, content, filter, skipToken);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => FetchSecondaryRecoveryPointsRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, location, content, filter, skipToken);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new DataProtectionBackupRecoveryPointResource(Client, DataProtectionBackupRecoveryPointData.DeserializeDataProtectionBackupRecoveryPointData(e)), FetchSecondaryRecoveryPointsClientDiagnostics, Pipeline, "MockableDataProtectionBackupResourceGroupResource.GetSecondaryRecoveryPoints", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Returns a list of Secondary Recovery Points for a DataSource in a vault, that can be used for Cross Region Restore.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/locations/{location}/fetchSecondaryRecoveryPoints</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>FetchSecondaryRecoveryPoints_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="location"> The name of the Azure region. </param>
        /// <param name="content"> Request body for operation. </param>
        /// <param name="filter"> OData filter options. </param>
        /// <param name="skipToken"> skipToken Filter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <returns> A collection of <see cref="DataProtectionBackupRecoveryPointResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<DataProtectionBackupRecoveryPointResource> GetSecondaryRecoveryPoints(AzureLocation location, FetchSecondaryRPsRequestContent content, string filter = null, string skipToken = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            HttpMessage FirstPageRequest(int? pageSizeHint) => FetchSecondaryRecoveryPointsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, location, content, filter, skipToken);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => FetchSecondaryRecoveryPointsRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, location, content, filter, skipToken);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new DataProtectionBackupRecoveryPointResource(Client, DataProtectionBackupRecoveryPointData.DeserializeDataProtectionBackupRecoveryPointData(e)), FetchSecondaryRecoveryPointsClientDiagnostics, Pipeline, "MockableDataProtectionBackupResourceGroupResource.GetSecondaryRecoveryPoints", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Fetches the Cross Region Restore Job
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/locations/{location}/fetchCrossRegionRestoreJob</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>FetchCrossRegionRestoreJob_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="location"> The name of the Azure region. </param>
        /// <param name="content"> Request body for operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        public virtual async Task<Response<DataProtectionBackupJobResource>> GetCrossRegionRestoreJobAsync(AzureLocation location, CrossRegionRestoreJobContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = FetchCrossRegionRestoreJobClientDiagnostics.CreateScope("MockableDataProtectionBackupResourceGroupResource.GetCrossRegionRestoreJob");
            scope.Start();
            try
            {
                var response = await FetchCrossRegionRestoreJobRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, location, content, cancellationToken).ConfigureAwait(false);
                return Response.FromValue(new DataProtectionBackupJobResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Fetches the Cross Region Restore Job
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/locations/{location}/fetchCrossRegionRestoreJob</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>FetchCrossRegionRestoreJob_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="location"> The name of the Azure region. </param>
        /// <param name="content"> Request body for operation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        public virtual Response<DataProtectionBackupJobResource> GetCrossRegionRestoreJob(AzureLocation location, CrossRegionRestoreJobContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = FetchCrossRegionRestoreJobClientDiagnostics.CreateScope("MockableDataProtectionBackupResourceGroupResource.GetCrossRegionRestoreJob");
            scope.Start();
            try
            {
                var response = FetchCrossRegionRestoreJobRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, location, content, cancellationToken);
                return Response.FromValue(new DataProtectionBackupJobResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Fetches list of Cross Region Restore job belonging to the vault
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/locations/{location}/fetchCrossRegionRestoreJobs</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>FetchCrossRegionRestoreJobs_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="location"> The name of the Azure region. </param>
        /// <param name="content"> Request body for operation. </param>
        /// <param name="filter"> OData filter options. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <returns> An async collection of <see cref="DataProtectionBackupJobResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<DataProtectionBackupJobResource> GetCrossRegionRestoreJobsAsync(AzureLocation location, CrossRegionRestoreJobsContent content, string filter = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            HttpMessage FirstPageRequest(int? pageSizeHint) => FetchCrossRegionRestoreJobsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, location, content, filter);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => FetchCrossRegionRestoreJobsRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, location, content, filter);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new DataProtectionBackupJobResource(Client, DataProtectionBackupJobData.DeserializeDataProtectionBackupJobData(e)), FetchCrossRegionRestoreJobsClientDiagnostics, Pipeline, "MockableDataProtectionBackupResourceGroupResource.GetCrossRegionRestoreJobs", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Fetches list of Cross Region Restore job belonging to the vault
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/locations/{location}/fetchCrossRegionRestoreJobs</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>FetchCrossRegionRestoreJobs_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="location"> The name of the Azure region. </param>
        /// <param name="content"> Request body for operation. </param>
        /// <param name="filter"> OData filter options. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <returns> A collection of <see cref="DataProtectionBackupJobResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<DataProtectionBackupJobResource> GetCrossRegionRestoreJobs(AzureLocation location, CrossRegionRestoreJobsContent content, string filter = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            HttpMessage FirstPageRequest(int? pageSizeHint) => FetchCrossRegionRestoreJobsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, location, content, filter);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => FetchCrossRegionRestoreJobsRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, location, content, filter);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new DataProtectionBackupJobResource(Client, DataProtectionBackupJobData.DeserializeDataProtectionBackupJobData(e)), FetchCrossRegionRestoreJobsClientDiagnostics, Pipeline, "MockableDataProtectionBackupResourceGroupResource.GetCrossRegionRestoreJobs", "value", "nextLink", cancellationToken);
        }
    }
}
