// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.DataMigration.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.DataMigration
{
    /// <summary>
    /// A class representing the Project data model.
    /// A project resource
    /// </summary>
    public partial class ProjectData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ProjectData"/>. </summary>
        /// <param name="location"> The location. </param>
        public ProjectData(AzureLocation location) : base(location)
        {
            DatabasesInfo = new ChangeTrackingList<DatabaseInfo>();
        }

        /// <summary> Initializes a new instance of <see cref="ProjectData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="etag"> HTTP strong entity tag value. This is ignored if submitted. </param>
        /// <param name="sourcePlatform"> Source platform for the project. </param>
        /// <param name="azureAuthenticationInfo"> Field that defines the Azure active directory application info, used to connect to the target Azure resource. </param>
        /// <param name="targetPlatform"> Target platform for the project. </param>
        /// <param name="createdOn"> UTC Date and time when project was created. </param>
        /// <param name="sourceConnectionInfo">
        /// Information for connecting to source
        /// Please note <see cref="ConnectionInfo"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MISqlConnectionInfo"/>, <see cref="MongoDBConnectionInfo"/>, <see cref="MySqlConnectionInfo"/>, <see cref="OracleConnectionInfo"/>, <see cref="PostgreSqlConnectionInfo"/> and <see cref="SqlConnectionInfo"/>.
        /// </param>
        /// <param name="targetConnectionInfo">
        /// Information for connecting to target
        /// Please note <see cref="ConnectionInfo"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MISqlConnectionInfo"/>, <see cref="MongoDBConnectionInfo"/>, <see cref="MySqlConnectionInfo"/>, <see cref="OracleConnectionInfo"/>, <see cref="PostgreSqlConnectionInfo"/> and <see cref="SqlConnectionInfo"/>.
        /// </param>
        /// <param name="databasesInfo"> List of DatabaseInfo. </param>
        /// <param name="provisioningState"> The project's provisioning state. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ProjectData(ResourceIdentifier id, string name, Core.ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, ETag? etag, ProjectSourcePlatform? sourcePlatform, AzureActiveDirectoryApp azureAuthenticationInfo, ProjectTargetPlatform? targetPlatform, DateTimeOffset? createdOn, ConnectionInfo sourceConnectionInfo, ConnectionInfo targetConnectionInfo, IList<DatabaseInfo> databasesInfo, ProjectProvisioningState? provisioningState, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            ETag = etag;
            SourcePlatform = sourcePlatform;
            AzureAuthenticationInfo = azureAuthenticationInfo;
            TargetPlatform = targetPlatform;
            CreatedOn = createdOn;
            SourceConnectionInfo = sourceConnectionInfo;
            TargetConnectionInfo = targetConnectionInfo;
            DatabasesInfo = databasesInfo;
            ProvisioningState = provisioningState;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ProjectData"/> for deserialization. </summary>
        internal ProjectData()
        {
        }

        /// <summary> HTTP strong entity tag value. This is ignored if submitted. </summary>
        public ETag? ETag { get; set; }
        /// <summary> Source platform for the project. </summary>
        public ProjectSourcePlatform? SourcePlatform { get; set; }
        /// <summary> Field that defines the Azure active directory application info, used to connect to the target Azure resource. </summary>
        public AzureActiveDirectoryApp AzureAuthenticationInfo { get; set; }
        /// <summary> Target platform for the project. </summary>
        public ProjectTargetPlatform? TargetPlatform { get; set; }
        /// <summary> UTC Date and time when project was created. </summary>
        public DateTimeOffset? CreatedOn { get; }
        /// <summary>
        /// Information for connecting to source
        /// Please note <see cref="ConnectionInfo"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MISqlConnectionInfo"/>, <see cref="MongoDBConnectionInfo"/>, <see cref="MySqlConnectionInfo"/>, <see cref="OracleConnectionInfo"/>, <see cref="PostgreSqlConnectionInfo"/> and <see cref="SqlConnectionInfo"/>.
        /// </summary>
        public ConnectionInfo SourceConnectionInfo { get; set; }
        /// <summary>
        /// Information for connecting to target
        /// Please note <see cref="ConnectionInfo"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MISqlConnectionInfo"/>, <see cref="MongoDBConnectionInfo"/>, <see cref="MySqlConnectionInfo"/>, <see cref="OracleConnectionInfo"/>, <see cref="PostgreSqlConnectionInfo"/> and <see cref="SqlConnectionInfo"/>.
        /// </summary>
        public ConnectionInfo TargetConnectionInfo { get; set; }
        /// <summary> List of DatabaseInfo. </summary>
        public IList<DatabaseInfo> DatabasesInfo { get; }
        /// <summary> The project's provisioning state. </summary>
        public ProjectProvisioningState? ProvisioningState { get; }
    }
}
