// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Output for task that validates migration input for SQL to Azure SQL Managed Instance migrations. </summary>
    public partial class ValidateMigrationInputSqlServerSqlMITaskOutput
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ValidateMigrationInputSqlServerSqlMITaskOutput"/>. </summary>
        internal ValidateMigrationInputSqlServerSqlMITaskOutput()
        {
            RestoreDatabaseNameErrors = new ChangeTrackingList<ReportableException>();
            BackupFolderErrors = new ChangeTrackingList<ReportableException>();
            BackupShareCredentialsErrors = new ChangeTrackingList<ReportableException>();
            BackupStorageAccountErrors = new ChangeTrackingList<ReportableException>();
            ExistingBackupErrors = new ChangeTrackingList<ReportableException>();
        }

        /// <summary> Initializes a new instance of <see cref="ValidateMigrationInputSqlServerSqlMITaskOutput"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="name"> Name of database. </param>
        /// <param name="restoreDatabaseNameErrors"> Errors associated with the RestoreDatabaseName. </param>
        /// <param name="backupFolderErrors"> Errors associated with the BackupFolder path. </param>
        /// <param name="backupShareCredentialsErrors"> Errors associated with backup share user name and password credentials. </param>
        /// <param name="backupStorageAccountErrors"> Errors associated with the storage account provided. </param>
        /// <param name="existingBackupErrors"> Errors associated with existing backup files. </param>
        /// <param name="databaseBackupInfo"> Information about backup files when existing backup mode is used. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ValidateMigrationInputSqlServerSqlMITaskOutput(string id, string name, IReadOnlyList<ReportableException> restoreDatabaseNameErrors, IReadOnlyList<ReportableException> backupFolderErrors, IReadOnlyList<ReportableException> backupShareCredentialsErrors, IReadOnlyList<ReportableException> backupStorageAccountErrors, IReadOnlyList<ReportableException> existingBackupErrors, DatabaseBackupInfo databaseBackupInfo, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            Name = name;
            RestoreDatabaseNameErrors = restoreDatabaseNameErrors;
            BackupFolderErrors = backupFolderErrors;
            BackupShareCredentialsErrors = backupShareCredentialsErrors;
            BackupStorageAccountErrors = backupStorageAccountErrors;
            ExistingBackupErrors = existingBackupErrors;
            DatabaseBackupInfo = databaseBackupInfo;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Result identifier. </summary>
        public string Id { get; }
        /// <summary> Name of database. </summary>
        public string Name { get; }
        /// <summary> Errors associated with the RestoreDatabaseName. </summary>
        public IReadOnlyList<ReportableException> RestoreDatabaseNameErrors { get; }
        /// <summary> Errors associated with the BackupFolder path. </summary>
        public IReadOnlyList<ReportableException> BackupFolderErrors { get; }
        /// <summary> Errors associated with backup share user name and password credentials. </summary>
        public IReadOnlyList<ReportableException> BackupShareCredentialsErrors { get; }
        /// <summary> Errors associated with the storage account provided. </summary>
        public IReadOnlyList<ReportableException> BackupStorageAccountErrors { get; }
        /// <summary> Errors associated with existing backup files. </summary>
        public IReadOnlyList<ReportableException> ExistingBackupErrors { get; }
        /// <summary> Information about backup files when existing backup mode is used. </summary>
        public DatabaseBackupInfo DatabaseBackupInfo { get; }
    }
}
