// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Type of the actual difference for the compared object, while performing schema comparison. </summary>
    public readonly partial struct UpdateActionType : IEquatable<UpdateActionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="UpdateActionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public UpdateActionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DeletedOnTargetValue = "DeletedOnTarget";
        private const string ChangedOnTargetValue = "ChangedOnTarget";
        private const string AddedOnTargetValue = "AddedOnTarget";

        /// <summary> DeletedOnTarget. </summary>
        public static UpdateActionType DeletedOnTarget { get; } = new UpdateActionType(DeletedOnTargetValue);
        /// <summary> ChangedOnTarget. </summary>
        public static UpdateActionType ChangedOnTarget { get; } = new UpdateActionType(ChangedOnTargetValue);
        /// <summary> AddedOnTarget. </summary>
        public static UpdateActionType AddedOnTarget { get; } = new UpdateActionType(AddedOnTargetValue);
        /// <summary> Determines if two <see cref="UpdateActionType"/> values are the same. </summary>
        public static bool operator ==(UpdateActionType left, UpdateActionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="UpdateActionType"/> values are not the same. </summary>
        public static bool operator !=(UpdateActionType left, UpdateActionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="UpdateActionType"/>. </summary>
        public static implicit operator UpdateActionType(string value) => new UpdateActionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is UpdateActionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(UpdateActionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
