// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Task type. </summary>
    internal readonly partial struct TaskType : IEquatable<TaskType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="TaskType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public TaskType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ConnectMongoDBValue = "Connect.MongoDb";
        private const string ConnectToSourceSqlServerValue = "ConnectToSource.SqlServer";
        private const string ConnectToSourceSqlServerSyncValue = "ConnectToSource.SqlServer.Sync";
        private const string ConnectToSourcePostgreSqlSyncValue = "ConnectToSource.PostgreSql.Sync";
        private const string ConnectToSourceMySqlValue = "ConnectToSource.MySql";
        private const string ConnectToSourceOracleSyncValue = "ConnectToSource.Oracle.Sync";
        private const string ConnectToTargetSqlDBValue = "ConnectToTarget.SqlDb";
        private const string ConnectToTargetSqlDBSyncValue = "ConnectToTarget.SqlDb.Sync";
        private const string ConnectToTargetAzureDBForPostgreSqlSyncValue = "ConnectToTarget.AzureDbForPostgreSql.Sync";
        private const string ConnectToTargetOracleAzureDBForPostgreSqlSyncValue = "ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync";
        private const string ConnectToTargetAzureSqlDBMIValue = "ConnectToTarget.AzureSqlDbMI";
        private const string ConnectToTargetAzureSqlDBMISyncLRSValue = "ConnectToTarget.AzureSqlDbMI.Sync.LRS";
        private const string ConnectToTargetAzureDBForMySqlValue = "ConnectToTarget.AzureDbForMySql";
        private const string GetUserTablesSqlValue = "GetUserTables.Sql";
        private const string GetUserTablesAzureSqlDBSyncValue = "GetUserTables.AzureSqlDb.Sync";
        private const string GetUserTablesOracleValue = "GetUserTablesOracle";
        private const string GetUserTablesPostgreSqlValue = "GetUserTablesPostgreSql";
        private const string GetUserTablesMySqlValue = "GetUserTablesMySql";
        private const string MigrateMongoDBValue = "Migrate.MongoDb";
        private const string MigrateSqlServerAzureSqlDBMIValue = "Migrate.SqlServer.AzureSqlDbMI";
        private const string MigrateSqlServerAzureSqlDBMISyncLRSValue = "Migrate.SqlServer.AzureSqlDbMI.Sync.LRS";
        private const string MigrateSqlServerSqlDBValue = "Migrate.SqlServer.SqlDb";
        private const string MigrateSqlServerAzureSqlDBSyncValue = "Migrate.SqlServer.AzureSqlDb.Sync";
        private const string MigrateMySqlAzureDBForMySqlSyncValue = "Migrate.MySql.AzureDbForMySql.Sync";
        private const string MigrateMySqlAzureDBForMySqlValue = "Migrate.MySql.AzureDbForMySql";
        private const string MigratePostgreSqlAzureDBForPostgreSqlSyncV2Value = "Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2";
        private const string MigrateOracleAzureDBForPostgreSqlSyncValue = "Migrate.Oracle.AzureDbForPostgreSql.Sync";
        private const string ValidateMigrationInputSqlServerSqlDBSyncValue = "ValidateMigrationInput.SqlServer.SqlDb.Sync";
        private const string ValidateMigrationInputSqlServerAzureSqlDBMIValue = "ValidateMigrationInput.SqlServer.AzureSqlDbMI";
        private const string ValidateMigrationInputSqlServerAzureSqlDBMISyncLRSValue = "ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS";
        private const string ValidateMongoDBValue = "Validate.MongoDb";
        private const string ValidateOracleAzureDBPostgreSqlSyncValue = "Validate.Oracle.AzureDbPostgreSql.Sync";
        private const string GetTDECertificatesSqlValue = "GetTDECertificates.Sql";
        private const string MigrateSsisValue = "Migrate.Ssis";
        private const string ServiceCheckOciValue = "Service.Check.OCI";
        private const string ServiceUploadOciValue = "Service.Upload.OCI";
        private const string ServiceInstallOciValue = "Service.Install.OCI";
        private const string MigrateSchemaSqlServerSqlDBValue = "MigrateSchemaSqlServerSqlDb";

        /// <summary> Connect.MongoDb. </summary>
        public static TaskType ConnectMongoDB { get; } = new TaskType(ConnectMongoDBValue);
        /// <summary> ConnectToSource.SqlServer. </summary>
        public static TaskType ConnectToSourceSqlServer { get; } = new TaskType(ConnectToSourceSqlServerValue);
        /// <summary> ConnectToSource.SqlServer.Sync. </summary>
        public static TaskType ConnectToSourceSqlServerSync { get; } = new TaskType(ConnectToSourceSqlServerSyncValue);
        /// <summary> ConnectToSource.PostgreSql.Sync. </summary>
        public static TaskType ConnectToSourcePostgreSqlSync { get; } = new TaskType(ConnectToSourcePostgreSqlSyncValue);
        /// <summary> ConnectToSource.MySql. </summary>
        public static TaskType ConnectToSourceMySql { get; } = new TaskType(ConnectToSourceMySqlValue);
        /// <summary> ConnectToSource.Oracle.Sync. </summary>
        public static TaskType ConnectToSourceOracleSync { get; } = new TaskType(ConnectToSourceOracleSyncValue);
        /// <summary> ConnectToTarget.SqlDb. </summary>
        public static TaskType ConnectToTargetSqlDB { get; } = new TaskType(ConnectToTargetSqlDBValue);
        /// <summary> ConnectToTarget.SqlDb.Sync. </summary>
        public static TaskType ConnectToTargetSqlDBSync { get; } = new TaskType(ConnectToTargetSqlDBSyncValue);
        /// <summary> ConnectToTarget.AzureDbForPostgreSql.Sync. </summary>
        public static TaskType ConnectToTargetAzureDBForPostgreSqlSync { get; } = new TaskType(ConnectToTargetAzureDBForPostgreSqlSyncValue);
        /// <summary> ConnectToTarget.Oracle.AzureDbForPostgreSql.Sync. </summary>
        public static TaskType ConnectToTargetOracleAzureDBForPostgreSqlSync { get; } = new TaskType(ConnectToTargetOracleAzureDBForPostgreSqlSyncValue);
        /// <summary> ConnectToTarget.AzureSqlDbMI. </summary>
        public static TaskType ConnectToTargetAzureSqlDBMI { get; } = new TaskType(ConnectToTargetAzureSqlDBMIValue);
        /// <summary> ConnectToTarget.AzureSqlDbMI.Sync.LRS. </summary>
        public static TaskType ConnectToTargetAzureSqlDBMISyncLRS { get; } = new TaskType(ConnectToTargetAzureSqlDBMISyncLRSValue);
        /// <summary> ConnectToTarget.AzureDbForMySql. </summary>
        public static TaskType ConnectToTargetAzureDBForMySql { get; } = new TaskType(ConnectToTargetAzureDBForMySqlValue);
        /// <summary> GetUserTables.Sql. </summary>
        public static TaskType GetUserTablesSql { get; } = new TaskType(GetUserTablesSqlValue);
        /// <summary> GetUserTables.AzureSqlDb.Sync. </summary>
        public static TaskType GetUserTablesAzureSqlDBSync { get; } = new TaskType(GetUserTablesAzureSqlDBSyncValue);
        /// <summary> GetUserTablesOracle. </summary>
        public static TaskType GetUserTablesOracle { get; } = new TaskType(GetUserTablesOracleValue);
        /// <summary> GetUserTablesPostgreSql. </summary>
        public static TaskType GetUserTablesPostgreSql { get; } = new TaskType(GetUserTablesPostgreSqlValue);
        /// <summary> GetUserTablesMySql. </summary>
        public static TaskType GetUserTablesMySql { get; } = new TaskType(GetUserTablesMySqlValue);
        /// <summary> Migrate.MongoDb. </summary>
        public static TaskType MigrateMongoDB { get; } = new TaskType(MigrateMongoDBValue);
        /// <summary> Migrate.SqlServer.AzureSqlDbMI. </summary>
        public static TaskType MigrateSqlServerAzureSqlDBMI { get; } = new TaskType(MigrateSqlServerAzureSqlDBMIValue);
        /// <summary> Migrate.SqlServer.AzureSqlDbMI.Sync.LRS. </summary>
        public static TaskType MigrateSqlServerAzureSqlDBMISyncLRS { get; } = new TaskType(MigrateSqlServerAzureSqlDBMISyncLRSValue);
        /// <summary> Migrate.SqlServer.SqlDb. </summary>
        public static TaskType MigrateSqlServerSqlDB { get; } = new TaskType(MigrateSqlServerSqlDBValue);
        /// <summary> Migrate.SqlServer.AzureSqlDb.Sync. </summary>
        public static TaskType MigrateSqlServerAzureSqlDBSync { get; } = new TaskType(MigrateSqlServerAzureSqlDBSyncValue);
        /// <summary> Migrate.MySql.AzureDbForMySql.Sync. </summary>
        public static TaskType MigrateMySqlAzureDBForMySqlSync { get; } = new TaskType(MigrateMySqlAzureDBForMySqlSyncValue);
        /// <summary> Migrate.MySql.AzureDbForMySql. </summary>
        public static TaskType MigrateMySqlAzureDBForMySql { get; } = new TaskType(MigrateMySqlAzureDBForMySqlValue);
        /// <summary> Migrate.PostgreSql.AzureDbForPostgreSql.SyncV2. </summary>
        public static TaskType MigratePostgreSqlAzureDBForPostgreSqlSyncV2 { get; } = new TaskType(MigratePostgreSqlAzureDBForPostgreSqlSyncV2Value);
        /// <summary> Migrate.Oracle.AzureDbForPostgreSql.Sync. </summary>
        public static TaskType MigrateOracleAzureDBForPostgreSqlSync { get; } = new TaskType(MigrateOracleAzureDBForPostgreSqlSyncValue);
        /// <summary> ValidateMigrationInput.SqlServer.SqlDb.Sync. </summary>
        public static TaskType ValidateMigrationInputSqlServerSqlDBSync { get; } = new TaskType(ValidateMigrationInputSqlServerSqlDBSyncValue);
        /// <summary> ValidateMigrationInput.SqlServer.AzureSqlDbMI. </summary>
        public static TaskType ValidateMigrationInputSqlServerAzureSqlDBMI { get; } = new TaskType(ValidateMigrationInputSqlServerAzureSqlDBMIValue);
        /// <summary> ValidateMigrationInput.SqlServer.AzureSqlDbMI.Sync.LRS. </summary>
        public static TaskType ValidateMigrationInputSqlServerAzureSqlDBMISyncLRS { get; } = new TaskType(ValidateMigrationInputSqlServerAzureSqlDBMISyncLRSValue);
        /// <summary> Validate.MongoDb. </summary>
        public static TaskType ValidateMongoDB { get; } = new TaskType(ValidateMongoDBValue);
        /// <summary> Validate.Oracle.AzureDbPostgreSql.Sync. </summary>
        public static TaskType ValidateOracleAzureDBPostgreSqlSync { get; } = new TaskType(ValidateOracleAzureDBPostgreSqlSyncValue);
        /// <summary> GetTDECertificates.Sql. </summary>
        public static TaskType GetTDECertificatesSql { get; } = new TaskType(GetTDECertificatesSqlValue);
        /// <summary> Migrate.Ssis. </summary>
        public static TaskType MigrateSsis { get; } = new TaskType(MigrateSsisValue);
        /// <summary> Service.Check.OCI. </summary>
        public static TaskType ServiceCheckOci { get; } = new TaskType(ServiceCheckOciValue);
        /// <summary> Service.Upload.OCI. </summary>
        public static TaskType ServiceUploadOci { get; } = new TaskType(ServiceUploadOciValue);
        /// <summary> Service.Install.OCI. </summary>
        public static TaskType ServiceInstallOci { get; } = new TaskType(ServiceInstallOciValue);
        /// <summary> MigrateSchemaSqlServerSqlDb. </summary>
        public static TaskType MigrateSchemaSqlServerSqlDB { get; } = new TaskType(MigrateSchemaSqlServerSqlDBValue);
        /// <summary> Determines if two <see cref="TaskType"/> values are the same. </summary>
        public static bool operator ==(TaskType left, TaskType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="TaskType"/> values are not the same. </summary>
        public static bool operator !=(TaskType left, TaskType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="TaskType"/>. </summary>
        public static implicit operator TaskType(string value) => new TaskType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is TaskType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(TaskType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
