// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Target Location details for optional copy of backups. </summary>
    public partial class TargetLocation
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="TargetLocation"/>. </summary>
        public TargetLocation()
        {
        }

        /// <summary> Initializes a new instance of <see cref="TargetLocation"/>. </summary>
        /// <param name="storageAccountResourceId"> Resource Id of the storage account copying backups. </param>
        /// <param name="accountKey"> Storage Account Key. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal TargetLocation(string storageAccountResourceId, string accountKey, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            StorageAccountResourceId = storageAccountResourceId;
            AccountKey = accountKey;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Resource Id of the storage account copying backups. </summary>
        public string StorageAccountResourceId { get; set; }
        /// <summary> Storage Account Key. </summary>
        public string AccountKey { get; set; }
    }
}
