// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Enum of the different state of table level online migration. </summary>
    public readonly partial struct SyncTableMigrationState : IEquatable<SyncTableMigrationState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SyncTableMigrationState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SyncTableMigrationState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BeforeLoadValue = "BEFORE_LOAD";
        private const string FullLoadValue = "FULL_LOAD";
        private const string CompletedValue = "COMPLETED";
        private const string CanceledValue = "CANCELED";
        private const string ErrorValue = "ERROR";
        private const string FailedValue = "FAILED";

        /// <summary> BEFORE_LOAD. </summary>
        public static SyncTableMigrationState BeforeLoad { get; } = new SyncTableMigrationState(BeforeLoadValue);
        /// <summary> FULL_LOAD. </summary>
        public static SyncTableMigrationState FullLoad { get; } = new SyncTableMigrationState(FullLoadValue);
        /// <summary> COMPLETED. </summary>
        public static SyncTableMigrationState Completed { get; } = new SyncTableMigrationState(CompletedValue);
        /// <summary> CANCELED. </summary>
        public static SyncTableMigrationState Canceled { get; } = new SyncTableMigrationState(CanceledValue);
        /// <summary> ERROR. </summary>
        public static SyncTableMigrationState Error { get; } = new SyncTableMigrationState(ErrorValue);
        /// <summary> FAILED. </summary>
        public static SyncTableMigrationState Failed { get; } = new SyncTableMigrationState(FailedValue);
        /// <summary> Determines if two <see cref="SyncTableMigrationState"/> values are the same. </summary>
        public static bool operator ==(SyncTableMigrationState left, SyncTableMigrationState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SyncTableMigrationState"/> values are not the same. </summary>
        public static bool operator !=(SyncTableMigrationState left, SyncTableMigrationState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SyncTableMigrationState"/>. </summary>
        public static implicit operator SyncTableMigrationState(string value) => new SyncTableMigrationState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SyncTableMigrationState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SyncTableMigrationState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
