// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Database migration errors for online migration. </summary>
    public partial class SyncMigrationDatabaseErrorEvent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SyncMigrationDatabaseErrorEvent"/>. </summary>
        internal SyncMigrationDatabaseErrorEvent()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SyncMigrationDatabaseErrorEvent"/>. </summary>
        /// <param name="timestampString"> String value of timestamp. </param>
        /// <param name="eventTypeString"> Event type. </param>
        /// <param name="eventText"> Event text. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SyncMigrationDatabaseErrorEvent(string timestampString, string eventTypeString, string eventText, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TimestampString = timestampString;
            EventTypeString = eventTypeString;
            EventText = eventText;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> String value of timestamp. </summary>
        public string TimestampString { get; }
        /// <summary> Event type. </summary>
        public string EventTypeString { get; }
        /// <summary> Event text. </summary>
        public string EventText { get; }
    }
}
