// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Enum of the different state of database level online migration. </summary>
    public readonly partial struct SyncDatabaseMigrationReportingState : IEquatable<SyncDatabaseMigrationReportingState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SyncDatabaseMigrationReportingState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SyncDatabaseMigrationReportingState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UndefinedValue = "UNDEFINED";
        private const string ConfiguringValue = "CONFIGURING";
        private const string InitialiazingValue = "INITIALIAZING";
        private const string StartingValue = "STARTING";
        private const string RunningValue = "RUNNING";
        private const string ReadyTOCompleteValue = "READY_TO_COMPLETE";
        private const string CompletingValue = "COMPLETING";
        private const string CompleteValue = "COMPLETE";
        private const string CancellingValue = "CANCELLING";
        private const string CancelledValue = "CANCELLED";
        private const string FailedValue = "FAILED";
        private const string ValidatingValue = "VALIDATING";
        private const string ValidationCompleteValue = "VALIDATION_COMPLETE";
        private const string ValidationFailedValue = "VALIDATION_FAILED";
        private const string RestoreINProgressValue = "RESTORE_IN_PROGRESS";
        private const string RestoreCompletedValue = "RESTORE_COMPLETED";
        private const string BackupINProgressValue = "BACKUP_IN_PROGRESS";
        private const string BackupCompletedValue = "BACKUP_COMPLETED";

        /// <summary> UNDEFINED. </summary>
        public static SyncDatabaseMigrationReportingState Undefined { get; } = new SyncDatabaseMigrationReportingState(UndefinedValue);
        /// <summary> CONFIGURING. </summary>
        public static SyncDatabaseMigrationReportingState Configuring { get; } = new SyncDatabaseMigrationReportingState(ConfiguringValue);
        /// <summary> INITIALIAZING. </summary>
        public static SyncDatabaseMigrationReportingState Initialiazing { get; } = new SyncDatabaseMigrationReportingState(InitialiazingValue);
        /// <summary> STARTING. </summary>
        public static SyncDatabaseMigrationReportingState Starting { get; } = new SyncDatabaseMigrationReportingState(StartingValue);
        /// <summary> RUNNING. </summary>
        public static SyncDatabaseMigrationReportingState Running { get; } = new SyncDatabaseMigrationReportingState(RunningValue);
        /// <summary> READY_TO_COMPLETE. </summary>
        public static SyncDatabaseMigrationReportingState ReadyTOComplete { get; } = new SyncDatabaseMigrationReportingState(ReadyTOCompleteValue);
        /// <summary> COMPLETING. </summary>
        public static SyncDatabaseMigrationReportingState Completing { get; } = new SyncDatabaseMigrationReportingState(CompletingValue);
        /// <summary> COMPLETE. </summary>
        public static SyncDatabaseMigrationReportingState Complete { get; } = new SyncDatabaseMigrationReportingState(CompleteValue);
        /// <summary> CANCELLING. </summary>
        public static SyncDatabaseMigrationReportingState Cancelling { get; } = new SyncDatabaseMigrationReportingState(CancellingValue);
        /// <summary> CANCELLED. </summary>
        public static SyncDatabaseMigrationReportingState Cancelled { get; } = new SyncDatabaseMigrationReportingState(CancelledValue);
        /// <summary> FAILED. </summary>
        public static SyncDatabaseMigrationReportingState Failed { get; } = new SyncDatabaseMigrationReportingState(FailedValue);
        /// <summary> VALIDATING. </summary>
        public static SyncDatabaseMigrationReportingState Validating { get; } = new SyncDatabaseMigrationReportingState(ValidatingValue);
        /// <summary> VALIDATION_COMPLETE. </summary>
        public static SyncDatabaseMigrationReportingState ValidationComplete { get; } = new SyncDatabaseMigrationReportingState(ValidationCompleteValue);
        /// <summary> VALIDATION_FAILED. </summary>
        public static SyncDatabaseMigrationReportingState ValidationFailed { get; } = new SyncDatabaseMigrationReportingState(ValidationFailedValue);
        /// <summary> RESTORE_IN_PROGRESS. </summary>
        public static SyncDatabaseMigrationReportingState RestoreINProgress { get; } = new SyncDatabaseMigrationReportingState(RestoreINProgressValue);
        /// <summary> RESTORE_COMPLETED. </summary>
        public static SyncDatabaseMigrationReportingState RestoreCompleted { get; } = new SyncDatabaseMigrationReportingState(RestoreCompletedValue);
        /// <summary> BACKUP_IN_PROGRESS. </summary>
        public static SyncDatabaseMigrationReportingState BackupINProgress { get; } = new SyncDatabaseMigrationReportingState(BackupINProgressValue);
        /// <summary> BACKUP_COMPLETED. </summary>
        public static SyncDatabaseMigrationReportingState BackupCompleted { get; } = new SyncDatabaseMigrationReportingState(BackupCompletedValue);
        /// <summary> Determines if two <see cref="SyncDatabaseMigrationReportingState"/> values are the same. </summary>
        public static bool operator ==(SyncDatabaseMigrationReportingState left, SyncDatabaseMigrationReportingState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SyncDatabaseMigrationReportingState"/> values are not the same. </summary>
        public static bool operator !=(SyncDatabaseMigrationReportingState left, SyncDatabaseMigrationReportingState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SyncDatabaseMigrationReportingState"/>. </summary>
        public static implicit operator SyncDatabaseMigrationReportingState(string value) => new SyncDatabaseMigrationReportingState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SyncDatabaseMigrationReportingState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SyncDatabaseMigrationReportingState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
