// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> An enumeration of supported source SSIS store type in DMS. </summary>
    public readonly partial struct SsisStoreType : IEquatable<SsisStoreType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SsisStoreType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SsisStoreType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SsisCatalogValue = "SsisCatalog";

        /// <summary> SsisCatalog. </summary>
        public static SsisStoreType SsisCatalog { get; } = new SsisStoreType(SsisCatalogValue);
        /// <summary> Determines if two <see cref="SsisStoreType"/> values are the same. </summary>
        public static bool operator ==(SsisStoreType left, SsisStoreType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SsisStoreType"/> values are not the same. </summary>
        public static bool operator !=(SsisStoreType left, SsisStoreType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SsisStoreType"/>. </summary>
        public static implicit operator SsisStoreType(string value) => new SsisStoreType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SsisStoreType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SsisStoreType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
