// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> File share. </summary>
    public partial class SqlFileShare
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SqlFileShare"/>. </summary>
        public SqlFileShare()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SqlFileShare"/>. </summary>
        /// <param name="path"> Location as SMB share or local drive where backups are placed. </param>
        /// <param name="username"> Username to access the file share location for backups. </param>
        /// <param name="password"> Password for username to access file share location. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SqlFileShare(string path, string username, string password, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Path = path;
            Username = username;
            Password = password;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Location as SMB share or local drive where backups are placed. </summary>
        public string Path { get; set; }
        /// <summary> Username to access the file share location for backups. </summary>
        public string Username { get; set; }
        /// <summary> Password for username to access file share location. </summary>
        public string Password { get; set; }
    }
}
