// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.DataMigration.Models
{
    public partial class SqlDBMigrationStatusDetails : IUtf8JsonSerializable, IJsonModel<SqlDBMigrationStatusDetails>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SqlDBMigrationStatusDetails>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SqlDBMigrationStatusDetails>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SqlDBMigrationStatusDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SqlDBMigrationStatusDetails)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(MigrationState))
            {
                writer.WritePropertyName("migrationState"u8);
                writer.WriteStringValue(MigrationState);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(SqlDataCopyErrors))
            {
                writer.WritePropertyName("sqlDataCopyErrors"u8);
                writer.WriteStartArray();
                foreach (var item in SqlDataCopyErrors)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(ListOfCopyProgressDetails))
            {
                writer.WritePropertyName("listOfCopyProgressDetails"u8);
                writer.WriteStartArray();
                foreach (var item in ListOfCopyProgressDetails)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        SqlDBMigrationStatusDetails IJsonModel<SqlDBMigrationStatusDetails>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SqlDBMigrationStatusDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SqlDBMigrationStatusDetails)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSqlDBMigrationStatusDetails(document.RootElement, options);
        }

        internal static SqlDBMigrationStatusDetails DeserializeSqlDBMigrationStatusDetails(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string migrationState = default;
            IReadOnlyList<string> sqlDataCopyErrors = default;
            IReadOnlyList<CopyProgressDetails> listOfCopyProgressDetails = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("migrationState"u8))
                {
                    migrationState = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("sqlDataCopyErrors"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    sqlDataCopyErrors = array;
                    continue;
                }
                if (property.NameEquals("listOfCopyProgressDetails"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<CopyProgressDetails> array = new List<CopyProgressDetails>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(CopyProgressDetails.DeserializeCopyProgressDetails(item, options));
                    }
                    listOfCopyProgressDetails = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SqlDBMigrationStatusDetails(migrationState, sqlDataCopyErrors ?? new ChangeTrackingList<string>(), listOfCopyProgressDetails ?? new ChangeTrackingList<CopyProgressDetails>(), serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<SqlDBMigrationStatusDetails>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SqlDBMigrationStatusDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(SqlDBMigrationStatusDetails)} does not support writing '{options.Format}' format.");
            }
        }

        SqlDBMigrationStatusDetails IPersistableModel<SqlDBMigrationStatusDetails>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SqlDBMigrationStatusDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSqlDBMigrationStatusDetails(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SqlDBMigrationStatusDetails)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SqlDBMigrationStatusDetails>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
