// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Source SQL Connection. </summary>
    public partial class SqlConnectionInformation
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SqlConnectionInformation"/>. </summary>
        public SqlConnectionInformation()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SqlConnectionInformation"/>. </summary>
        /// <param name="dataSource"> Data source. </param>
        /// <param name="authentication"> Authentication type. </param>
        /// <param name="userName"> User name to connect to source SQL. </param>
        /// <param name="password"> Password to connect to source SQL. </param>
        /// <param name="encryptConnection"> Whether to encrypt connection or not. </param>
        /// <param name="trustServerCertificate"> Whether to trust server certificate or not. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SqlConnectionInformation(string dataSource, string authentication, string userName, string password, bool? encryptConnection, bool? trustServerCertificate, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DataSource = dataSource;
            Authentication = authentication;
            UserName = userName;
            Password = password;
            EncryptConnection = encryptConnection;
            TrustServerCertificate = trustServerCertificate;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Data source. </summary>
        public string DataSource { get; set; }
        /// <summary> Authentication type. </summary>
        public string Authentication { get; set; }
        /// <summary> User name to connect to source SQL. </summary>
        public string UserName { get; set; }
        /// <summary> Password to connect to source SQL. </summary>
        public string Password { get; set; }
        /// <summary> Whether to encrypt connection or not. </summary>
        public bool? EncryptConnection { get; set; }
        /// <summary> Whether to trust server certificate or not. </summary>
        public bool? TrustServerCertificate { get; set; }
    }
}
