// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Information for connecting to SQL database server. </summary>
    public partial class SqlConnectionInfo : ConnectionInfo
    {
        /// <summary> Initializes a new instance of <see cref="SqlConnectionInfo"/>. </summary>
        /// <param name="dataSource"> Data source in the format Protocol:MachineName\SQLServerInstanceName,PortNumber. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="dataSource"/> is null. </exception>
        public SqlConnectionInfo(string dataSource)
        {
            Argument.AssertNotNull(dataSource, nameof(dataSource));

            DataSource = dataSource;
            ConnectionInfoType = "SqlConnectionInfo";
        }

        /// <summary> Initializes a new instance of <see cref="SqlConnectionInfo"/>. </summary>
        /// <param name="connectionInfoType"> Type of connection info. </param>
        /// <param name="userName"> User name. </param>
        /// <param name="password"> Password credential. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="dataSource"> Data source in the format Protocol:MachineName\SQLServerInstanceName,PortNumber. </param>
        /// <param name="serverName"> name of the server. </param>
        /// <param name="port"> Port for Server. </param>
        /// <param name="serverVersion"> server version. </param>
        /// <param name="serverBrandVersion"> server brand version. </param>
        /// <param name="resourceId"> Represents the ID of an HTTP resource represented by an Azure resource provider. </param>
        /// <param name="authentication"> Authentication type to use for connection. </param>
        /// <param name="encryptConnection"> Whether to encrypt the connection. </param>
        /// <param name="additionalSettings"> Additional connection settings. </param>
        /// <param name="trustServerCertificate"> Whether to trust the server certificate. </param>
        /// <param name="platform"> Server platform type for connection. </param>
        internal SqlConnectionInfo(string connectionInfoType, string userName, string password, IDictionary<string, BinaryData> serializedAdditionalRawData, string dataSource, string serverName, int? port, string serverVersion, string serverBrandVersion, string resourceId, AuthenticationType? authentication, bool? encryptConnection, string additionalSettings, bool? trustServerCertificate, SqlSourcePlatform? platform) : base(connectionInfoType, userName, password, serializedAdditionalRawData)
        {
            DataSource = dataSource;
            ServerName = serverName;
            Port = port;
            ServerVersion = serverVersion;
            ServerBrandVersion = serverBrandVersion;
            ResourceId = resourceId;
            Authentication = authentication;
            EncryptConnection = encryptConnection;
            AdditionalSettings = additionalSettings;
            TrustServerCertificate = trustServerCertificate;
            Platform = platform;
            ConnectionInfoType = connectionInfoType ?? "SqlConnectionInfo";
        }

        /// <summary> Initializes a new instance of <see cref="SqlConnectionInfo"/> for deserialization. </summary>
        internal SqlConnectionInfo()
        {
        }

        /// <summary> Data source in the format Protocol:MachineName\SQLServerInstanceName,PortNumber. </summary>
        public string DataSource { get; set; }
        /// <summary> name of the server. </summary>
        public string ServerName { get; set; }
        /// <summary> Port for Server. </summary>
        public int? Port { get; set; }
        /// <summary> server version. </summary>
        public string ServerVersion { get; set; }
        /// <summary> server brand version. </summary>
        public string ServerBrandVersion { get; set; }
        /// <summary> Represents the ID of an HTTP resource represented by an Azure resource provider. </summary>
        public string ResourceId { get; set; }
        /// <summary> Authentication type to use for connection. </summary>
        public AuthenticationType? Authentication { get; set; }
        /// <summary> Whether to encrypt the connection. </summary>
        public bool? EncryptConnection { get; set; }
        /// <summary> Additional connection settings. </summary>
        public string AdditionalSettings { get; set; }
        /// <summary> Whether to trust the server certificate. </summary>
        public bool? TrustServerCertificate { get; set; }
        /// <summary> Server platform type for connection. </summary>
        public SqlSourcePlatform? Platform { get; set; }
    }
}
