// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Information of backup file. </summary>
    public partial class SqlBackupFileInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SqlBackupFileInfo"/>. </summary>
        internal SqlBackupFileInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SqlBackupFileInfo"/>. </summary>
        /// <param name="fileName"> File name. </param>
        /// <param name="status"> Status of the file. (Initial, Uploading, Uploaded, Restoring, Restored or Skipped). </param>
        /// <param name="totalSize"> File size in bytes. </param>
        /// <param name="dataRead"> Bytes read. </param>
        /// <param name="dataWritten"> Bytes written. </param>
        /// <param name="copyThroughput"> Copy throughput in KBps. </param>
        /// <param name="copyDuration"> Copy Duration in seconds. </param>
        /// <param name="familySequenceNumber"> Media family sequence number. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SqlBackupFileInfo(string fileName, string status, long? totalSize, long? dataRead, long? dataWritten, double? copyThroughput, int? copyDuration, int? familySequenceNumber, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            FileName = fileName;
            Status = status;
            TotalSize = totalSize;
            DataRead = dataRead;
            DataWritten = dataWritten;
            CopyThroughput = copyThroughput;
            CopyDuration = copyDuration;
            FamilySequenceNumber = familySequenceNumber;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> File name. </summary>
        public string FileName { get; }
        /// <summary> Status of the file. (Initial, Uploading, Uploaded, Restoring, Restored or Skipped). </summary>
        public string Status { get; }
        /// <summary> File size in bytes. </summary>
        public long? TotalSize { get; }
        /// <summary> Bytes read. </summary>
        public long? DataRead { get; }
        /// <summary> Bytes written. </summary>
        public long? DataWritten { get; }
        /// <summary> Copy throughput in KBps. </summary>
        public double? CopyThroughput { get; }
        /// <summary> Copy Duration in seconds. </summary>
        public int? CopyDuration { get; }
        /// <summary> Media family sequence number. </summary>
        public int? FamilySequenceNumber { get; }
    }
}
