// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.DataMigration.Models
{
    public partial class SourceLocation : IUtf8JsonSerializable, IJsonModel<SourceLocation>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SourceLocation>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SourceLocation>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SourceLocation>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SourceLocation)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(FileShare))
            {
                writer.WritePropertyName("fileShare"u8);
                writer.WriteObjectValue(FileShare, options);
            }
            if (Optional.IsDefined(AzureBlob))
            {
                writer.WritePropertyName("azureBlob"u8);
                writer.WriteObjectValue(AzureBlob, options);
            }
            if (options.Format != "W" && Optional.IsDefined(FileStorageType))
            {
                writer.WritePropertyName("fileStorageType"u8);
                writer.WriteStringValue(FileStorageType);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        SourceLocation IJsonModel<SourceLocation>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SourceLocation>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SourceLocation)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSourceLocation(document.RootElement, options);
        }

        internal static SourceLocation DeserializeSourceLocation(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            SqlFileShare fileShare = default;
            AzureBlob azureBlob = default;
            string fileStorageType = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("fileShare"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    fileShare = SqlFileShare.DeserializeSqlFileShare(property.Value, options);
                    continue;
                }
                if (property.NameEquals("azureBlob"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    azureBlob = AzureBlob.DeserializeAzureBlob(property.Value, options);
                    continue;
                }
                if (property.NameEquals("fileStorageType"u8))
                {
                    fileStorageType = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SourceLocation(fileShare, azureBlob, fileStorageType, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<SourceLocation>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SourceLocation>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(SourceLocation)} does not support writing '{options.Format}' format.");
            }
        }

        SourceLocation IPersistableModel<SourceLocation>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SourceLocation>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSourceLocation(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SourceLocation)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SourceLocation>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
