// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Severity of the validation error. </summary>
    public readonly partial struct Severity : IEquatable<Severity>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="Severity"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public Severity(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MessageValue = "Message";
        private const string WarningValue = "Warning";
        private const string ErrorValue = "Error";

        /// <summary> Message. </summary>
        public static Severity Message { get; } = new Severity(MessageValue);
        /// <summary> Warning. </summary>
        public static Severity Warning { get; } = new Severity(WarningValue);
        /// <summary> Error. </summary>
        public static Severity Error { get; } = new Severity(ErrorValue);
        /// <summary> Determines if two <see cref="Severity"/> values are the same. </summary>
        public static bool operator ==(Severity left, Severity right) => left.Equals(right);
        /// <summary> Determines if two <see cref="Severity"/> values are not the same. </summary>
        public static bool operator !=(Severity left, Severity right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="Severity"/>. </summary>
        public static implicit operator Severity(string value) => new Severity(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is Severity other && Equals(other);
        /// <inheritdoc />
        public bool Equals(Severity other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
