// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> The scalability approach. </summary>
    public readonly partial struct ServiceScalability : IEquatable<ServiceScalability>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ServiceScalability"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ServiceScalability(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "none";
        private const string ManualValue = "manual";
        private const string AutomaticValue = "automatic";

        /// <summary> none. </summary>
        public static ServiceScalability None { get; } = new ServiceScalability(NoneValue);
        /// <summary> manual. </summary>
        public static ServiceScalability Manual { get; } = new ServiceScalability(ManualValue);
        /// <summary> automatic. </summary>
        public static ServiceScalability Automatic { get; } = new ServiceScalability(AutomaticValue);
        /// <summary> Determines if two <see cref="ServiceScalability"/> values are the same. </summary>
        public static bool operator ==(ServiceScalability left, ServiceScalability right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ServiceScalability"/> values are not the same. </summary>
        public static bool operator !=(ServiceScalability left, ServiceScalability right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ServiceScalability"/>. </summary>
        public static implicit operator ServiceScalability(string value) => new ServiceScalability(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ServiceScalability other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ServiceScalability other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
