// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.DataMigration.Models
{
    public partial class ServerProperties : IUtf8JsonSerializable, IJsonModel<ServerProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ServerProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ServerProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServerProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ServerProperties)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(ServerPlatform))
            {
                writer.WritePropertyName("serverPlatform"u8);
                writer.WriteStringValue(ServerPlatform);
            }
            if (options.Format != "W" && Optional.IsDefined(ServerName))
            {
                writer.WritePropertyName("serverName"u8);
                writer.WriteStringValue(ServerName);
            }
            if (options.Format != "W" && Optional.IsDefined(ServerVersion))
            {
                writer.WritePropertyName("serverVersion"u8);
                writer.WriteStringValue(ServerVersion);
            }
            if (options.Format != "W" && Optional.IsDefined(ServerEdition))
            {
                writer.WritePropertyName("serverEdition"u8);
                writer.WriteStringValue(ServerEdition);
            }
            if (options.Format != "W" && Optional.IsDefined(ServerOperatingSystemVersion))
            {
                writer.WritePropertyName("serverOperatingSystemVersion"u8);
                writer.WriteStringValue(ServerOperatingSystemVersion);
            }
            if (options.Format != "W" && Optional.IsDefined(ServerDatabaseCount))
            {
                writer.WritePropertyName("serverDatabaseCount"u8);
                writer.WriteNumberValue(ServerDatabaseCount.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ServerProperties IJsonModel<ServerProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServerProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ServerProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeServerProperties(document.RootElement, options);
        }

        internal static ServerProperties DeserializeServerProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string serverPlatform = default;
            string serverName = default;
            string serverVersion = default;
            string serverEdition = default;
            string serverOperatingSystemVersion = default;
            int? serverDatabaseCount = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("serverPlatform"u8))
                {
                    serverPlatform = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("serverName"u8))
                {
                    serverName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("serverVersion"u8))
                {
                    serverVersion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("serverEdition"u8))
                {
                    serverEdition = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("serverOperatingSystemVersion"u8))
                {
                    serverOperatingSystemVersion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("serverDatabaseCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    serverDatabaseCount = property.Value.GetInt32();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ServerProperties(
                serverPlatform,
                serverName,
                serverVersion,
                serverEdition,
                serverOperatingSystemVersion,
                serverDatabaseCount,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ServerProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServerProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ServerProperties)} does not support writing '{options.Format}' format.");
            }
        }

        ServerProperties IPersistableModel<ServerProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ServerProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeServerProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ServerProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ServerProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
