// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Current stage of schema migration. </summary>
    public readonly partial struct SchemaMigrationStage : IEquatable<SchemaMigrationStage>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SchemaMigrationStage"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SchemaMigrationStage(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotStartedValue = "NotStarted";
        private const string ValidatingInputsValue = "ValidatingInputs";
        private const string CollectingObjectsValue = "CollectingObjects";
        private const string DownloadingScriptValue = "DownloadingScript";
        private const string GeneratingScriptValue = "GeneratingScript";
        private const string UploadingScriptValue = "UploadingScript";
        private const string DeployingSchemaValue = "DeployingSchema";
        private const string CompletedValue = "Completed";
        private const string CompletedWithWarningsValue = "CompletedWithWarnings";
        private const string FailedValue = "Failed";

        /// <summary> NotStarted. </summary>
        public static SchemaMigrationStage NotStarted { get; } = new SchemaMigrationStage(NotStartedValue);
        /// <summary> ValidatingInputs. </summary>
        public static SchemaMigrationStage ValidatingInputs { get; } = new SchemaMigrationStage(ValidatingInputsValue);
        /// <summary> CollectingObjects. </summary>
        public static SchemaMigrationStage CollectingObjects { get; } = new SchemaMigrationStage(CollectingObjectsValue);
        /// <summary> DownloadingScript. </summary>
        public static SchemaMigrationStage DownloadingScript { get; } = new SchemaMigrationStage(DownloadingScriptValue);
        /// <summary> GeneratingScript. </summary>
        public static SchemaMigrationStage GeneratingScript { get; } = new SchemaMigrationStage(GeneratingScriptValue);
        /// <summary> UploadingScript. </summary>
        public static SchemaMigrationStage UploadingScript { get; } = new SchemaMigrationStage(UploadingScriptValue);
        /// <summary> DeployingSchema. </summary>
        public static SchemaMigrationStage DeployingSchema { get; } = new SchemaMigrationStage(DeployingSchemaValue);
        /// <summary> Completed. </summary>
        public static SchemaMigrationStage Completed { get; } = new SchemaMigrationStage(CompletedValue);
        /// <summary> CompletedWithWarnings. </summary>
        public static SchemaMigrationStage CompletedWithWarnings { get; } = new SchemaMigrationStage(CompletedWithWarningsValue);
        /// <summary> Failed. </summary>
        public static SchemaMigrationStage Failed { get; } = new SchemaMigrationStage(FailedValue);
        /// <summary> Determines if two <see cref="SchemaMigrationStage"/> values are the same. </summary>
        public static bool operator ==(SchemaMigrationStage left, SchemaMigrationStage right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SchemaMigrationStage"/> values are not the same. </summary>
        public static bool operator !=(SchemaMigrationStage left, SchemaMigrationStage right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SchemaMigrationStage"/>. </summary>
        public static implicit operator SchemaMigrationStage(string value) => new SchemaMigrationStage(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SchemaMigrationStage other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SchemaMigrationStage other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
