// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Settings for migrating schema from source to target. </summary>
    public partial class SchemaMigrationSetting
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SchemaMigrationSetting"/>. </summary>
        public SchemaMigrationSetting()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SchemaMigrationSetting"/>. </summary>
        /// <param name="schemaOption"> Option on how to migrate the schema. </param>
        /// <param name="fileId"> Resource Identifier of a file resource containing the uploaded schema file. </param>
        /// <param name="fileName"> Name of the file resource containing the uploaded schema file. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SchemaMigrationSetting(SchemaMigrationOption? schemaOption, string fileId, string fileName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SchemaOption = schemaOption;
            FileId = fileId;
            FileName = fileName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Option on how to migrate the schema. </summary>
        public SchemaMigrationOption? SchemaOption { get; set; }
        /// <summary> Resource Identifier of a file resource containing the uploaded schema file. </summary>
        public string FileId { get; set; }
        /// <summary> Name of the file resource containing the uploaded schema file. </summary>
        public string FileName { get; set; }
    }
}
