// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Option for how schema is extracted and applied to target. </summary>
    public readonly partial struct SchemaMigrationOption : IEquatable<SchemaMigrationOption>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SchemaMigrationOption"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SchemaMigrationOption(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string ExtractFromSourceValue = "ExtractFromSource";
        private const string UseStorageFileValue = "UseStorageFile";

        /// <summary> None. </summary>
        public static SchemaMigrationOption None { get; } = new SchemaMigrationOption(NoneValue);
        /// <summary> ExtractFromSource. </summary>
        public static SchemaMigrationOption ExtractFromSource { get; } = new SchemaMigrationOption(ExtractFromSourceValue);
        /// <summary> UseStorageFile. </summary>
        public static SchemaMigrationOption UseStorageFile { get; } = new SchemaMigrationOption(UseStorageFileValue);
        /// <summary> Determines if two <see cref="SchemaMigrationOption"/> values are the same. </summary>
        public static bool operator ==(SchemaMigrationOption left, SchemaMigrationOption right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SchemaMigrationOption"/> values are not the same. </summary>
        public static bool operator !=(SchemaMigrationOption left, SchemaMigrationOption right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SchemaMigrationOption"/>. </summary>
        public static implicit operator SchemaMigrationOption(string value) => new SchemaMigrationOption(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SchemaMigrationOption other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SchemaMigrationOption other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
