// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Description about the errors happen while performing migration validation. </summary>
    public partial class SchemaComparisonValidationResultType
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SchemaComparisonValidationResultType"/>. </summary>
        internal SchemaComparisonValidationResultType()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SchemaComparisonValidationResultType"/>. </summary>
        /// <param name="objectName"> Name of the object that has the difference. </param>
        /// <param name="objectType"> Type of the object that has the difference. e.g (Table/View/StoredProcedure). </param>
        /// <param name="updateAction"> Update action type with respect to target. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SchemaComparisonValidationResultType(string objectName, ObjectType? objectType, UpdateActionType? updateAction, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ObjectName = objectName;
            ObjectType = objectType;
            UpdateAction = updateAction;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of the object that has the difference. </summary>
        public string ObjectName { get; }
        /// <summary> Type of the object that has the difference. e.g (Table/View/StoredProcedure). </summary>
        public ObjectType? ObjectType { get; }
        /// <summary> Update action type with respect to target. </summary>
        public UpdateActionType? UpdateAction { get; }
    }
}
