// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> An enumeration of target type. </summary>
    public readonly partial struct ScenarioTarget : IEquatable<ScenarioTarget>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ScenarioTarget"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ScenarioTarget(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SqlServerValue = "SQLServer";
        private const string SqlDBValue = "SQLDB";
        private const string SqlDWValue = "SQLDW";
        private const string SqlMIValue = "SQLMI";
        private const string AzureDBForMySqlValue = "AzureDBForMySql";
        private const string AzureDBForPostgresSqlValue = "AzureDBForPostgresSQL";
        private const string MongoDBValue = "MongoDB";

        /// <summary> SQLServer. </summary>
        public static ScenarioTarget SqlServer { get; } = new ScenarioTarget(SqlServerValue);
        /// <summary> SQLDB. </summary>
        public static ScenarioTarget SqlDB { get; } = new ScenarioTarget(SqlDBValue);
        /// <summary> SQLDW. </summary>
        public static ScenarioTarget SqlDW { get; } = new ScenarioTarget(SqlDWValue);
        /// <summary> SQLMI. </summary>
        public static ScenarioTarget SqlMI { get; } = new ScenarioTarget(SqlMIValue);
        /// <summary> AzureDBForMySql. </summary>
        public static ScenarioTarget AzureDBForMySql { get; } = new ScenarioTarget(AzureDBForMySqlValue);
        /// <summary> AzureDBForPostgresSQL. </summary>
        public static ScenarioTarget AzureDBForPostgresSql { get; } = new ScenarioTarget(AzureDBForPostgresSqlValue);
        /// <summary> MongoDB. </summary>
        public static ScenarioTarget MongoDB { get; } = new ScenarioTarget(MongoDBValue);
        /// <summary> Determines if two <see cref="ScenarioTarget"/> values are the same. </summary>
        public static bool operator ==(ScenarioTarget left, ScenarioTarget right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ScenarioTarget"/> values are not the same. </summary>
        public static bool operator !=(ScenarioTarget left, ScenarioTarget right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ScenarioTarget"/>. </summary>
        public static implicit operator ScenarioTarget(string value) => new ScenarioTarget(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ScenarioTarget other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ScenarioTarget other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
