// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> An enumeration of source type. </summary>
    public readonly partial struct ScenarioSource : IEquatable<ScenarioSource>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ScenarioSource"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ScenarioSource(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AccessValue = "Access";
        private const string DB2Value = "DB2";
        private const string MySqlValue = "MySQL";
        private const string OracleValue = "Oracle";
        private const string SqlValue = "SQL";
        private const string SybaseValue = "Sybase";
        private const string PostgreSqlValue = "PostgreSQL";
        private const string MongoDBValue = "MongoDB";
        private const string SqlrdsValue = "SQLRDS";
        private const string MySqlrdsValue = "MySQLRDS";
        private const string PostgreSqlrdsValue = "PostgreSQLRDS";

        /// <summary> Access. </summary>
        public static ScenarioSource Access { get; } = new ScenarioSource(AccessValue);
        /// <summary> DB2. </summary>
        public static ScenarioSource DB2 { get; } = new ScenarioSource(DB2Value);
        /// <summary> MySQL. </summary>
        public static ScenarioSource MySql { get; } = new ScenarioSource(MySqlValue);
        /// <summary> Oracle. </summary>
        public static ScenarioSource Oracle { get; } = new ScenarioSource(OracleValue);
        /// <summary> SQL. </summary>
        public static ScenarioSource Sql { get; } = new ScenarioSource(SqlValue);
        /// <summary> Sybase. </summary>
        public static ScenarioSource Sybase { get; } = new ScenarioSource(SybaseValue);
        /// <summary> PostgreSQL. </summary>
        public static ScenarioSource PostgreSql { get; } = new ScenarioSource(PostgreSqlValue);
        /// <summary> MongoDB. </summary>
        public static ScenarioSource MongoDB { get; } = new ScenarioSource(MongoDBValue);
        /// <summary> SQLRDS. </summary>
        public static ScenarioSource Sqlrds { get; } = new ScenarioSource(SqlrdsValue);
        /// <summary> MySQLRDS. </summary>
        public static ScenarioSource MySqlrds { get; } = new ScenarioSource(MySqlrdsValue);
        /// <summary> PostgreSQLRDS. </summary>
        public static ScenarioSource PostgreSqlrds { get; } = new ScenarioSource(PostgreSqlrdsValue);
        /// <summary> Determines if two <see cref="ScenarioSource"/> values are the same. </summary>
        public static bool operator ==(ScenarioSource left, ScenarioSource right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ScenarioSource"/> values are not the same. </summary>
        public static bool operator !=(ScenarioSource left, ScenarioSource right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ScenarioSource"/>. </summary>
        public static implicit operator ScenarioSource(string value) => new ScenarioSource(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ScenarioSource other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ScenarioSource other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
