// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> The ResourceType. </summary>
    internal readonly partial struct ResourceType : IEquatable<ResourceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ResourceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ResourceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SqlMIValue = "SqlMi";
        private const string SqlVmValue = "SqlVm";
        private const string SqlDBValue = "SqlDb";

        /// <summary> SqlMi. </summary>
        public static ResourceType SqlMI { get; } = new ResourceType(SqlMIValue);
        /// <summary> SqlVm. </summary>
        public static ResourceType SqlVm { get; } = new ResourceType(SqlVmValue);
        /// <summary> SqlDb. </summary>
        public static ResourceType SqlDB { get; } = new ResourceType(SqlDBValue);
        /// <summary> Determines if two <see cref="ResourceType"/> values are the same. </summary>
        public static bool operator ==(ResourceType left, ResourceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ResourceType"/> values are not the same. </summary>
        public static bool operator !=(ResourceType left, ResourceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ResourceType"/>. </summary>
        public static implicit operator ResourceType(string value) => new ResourceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ResourceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ResourceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
