// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> The scale type applicable to the SKU. </summary>
    public readonly partial struct ResourceSkuCapacityScaleType : IEquatable<ResourceSkuCapacityScaleType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ResourceSkuCapacityScaleType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ResourceSkuCapacityScaleType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AutomaticValue = "Automatic";
        private const string ManualValue = "Manual";
        private const string NoneValue = "None";

        /// <summary> Automatic. </summary>
        public static ResourceSkuCapacityScaleType Automatic { get; } = new ResourceSkuCapacityScaleType(AutomaticValue);
        /// <summary> Manual. </summary>
        public static ResourceSkuCapacityScaleType Manual { get; } = new ResourceSkuCapacityScaleType(ManualValue);
        /// <summary> None. </summary>
        public static ResourceSkuCapacityScaleType None { get; } = new ResourceSkuCapacityScaleType(NoneValue);
        /// <summary> Determines if two <see cref="ResourceSkuCapacityScaleType"/> values are the same. </summary>
        public static bool operator ==(ResourceSkuCapacityScaleType left, ResourceSkuCapacityScaleType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ResourceSkuCapacityScaleType"/> values are not the same. </summary>
        public static bool operator !=(ResourceSkuCapacityScaleType left, ResourceSkuCapacityScaleType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ResourceSkuCapacityScaleType"/>. </summary>
        public static implicit operator ResourceSkuCapacityScaleType(string value) => new ResourceSkuCapacityScaleType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ResourceSkuCapacityScaleType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ResourceSkuCapacityScaleType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
