// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Wrapper for replicate reported migration states. </summary>
    public readonly partial struct ReplicateMigrationState : IEquatable<ReplicateMigrationState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ReplicateMigrationState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ReplicateMigrationState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UndefinedValue = "UNDEFINED";
        private const string ValidatingValue = "VALIDATING";
        private const string PendingValue = "PENDING";
        private const string CompleteValue = "COMPLETE";
        private const string ActionRequiredValue = "ACTION_REQUIRED";
        private const string FailedValue = "FAILED";

        /// <summary> UNDEFINED. </summary>
        public static ReplicateMigrationState Undefined { get; } = new ReplicateMigrationState(UndefinedValue);
        /// <summary> VALIDATING. </summary>
        public static ReplicateMigrationState Validating { get; } = new ReplicateMigrationState(ValidatingValue);
        /// <summary> PENDING. </summary>
        public static ReplicateMigrationState Pending { get; } = new ReplicateMigrationState(PendingValue);
        /// <summary> COMPLETE. </summary>
        public static ReplicateMigrationState Complete { get; } = new ReplicateMigrationState(CompleteValue);
        /// <summary> ACTION_REQUIRED. </summary>
        public static ReplicateMigrationState ActionRequired { get; } = new ReplicateMigrationState(ActionRequiredValue);
        /// <summary> FAILED. </summary>
        public static ReplicateMigrationState Failed { get; } = new ReplicateMigrationState(FailedValue);
        /// <summary> Determines if two <see cref="ReplicateMigrationState"/> values are the same. </summary>
        public static bool operator ==(ReplicateMigrationState left, ReplicateMigrationState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ReplicateMigrationState"/> values are not the same. </summary>
        public static bool operator !=(ReplicateMigrationState left, ReplicateMigrationState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ReplicateMigrationState"/>. </summary>
        public static implicit operator ReplicateMigrationState(string value) => new ReplicateMigrationState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ReplicateMigrationState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ReplicateMigrationState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
