// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> An authentication key to regenerate. </summary>
    public partial class RegenAuthKeys
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RegenAuthKeys"/>. </summary>
        public RegenAuthKeys()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RegenAuthKeys"/>. </summary>
        /// <param name="keyName"> The name of authentication key to generate. </param>
        /// <param name="authKey1"> The first authentication key. </param>
        /// <param name="authKey2"> The second authentication key. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RegenAuthKeys(string keyName, string authKey1, string authKey2, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            KeyName = keyName;
            AuthKey1 = authKey1;
            AuthKey2 = authKey2;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The name of authentication key to generate. </summary>
        public string KeyName { get; set; }
        /// <summary> The first authentication key. </summary>
        public string AuthKey1 { get; set; }
        /// <summary> The second authentication key. </summary>
        public string AuthKey2 { get; set; }
    }
}
