// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Target platform of the project. </summary>
    public readonly partial struct ProjectTargetPlatform : IEquatable<ProjectTargetPlatform>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ProjectTargetPlatform"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ProjectTargetPlatform(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SqlDBValue = "SQLDB";
        private const string SqlMIValue = "SQLMI";
        private const string AzureDBForMySqlValue = "AzureDbForMySql";
        private const string AzureDBForPostgreSqlValue = "AzureDbForPostgreSql";
        private const string MongoDBValue = "MongoDb";
        private const string UnknownValue = "Unknown";

        /// <summary> SQLDB. </summary>
        public static ProjectTargetPlatform SqlDB { get; } = new ProjectTargetPlatform(SqlDBValue);
        /// <summary> SQLMI. </summary>
        public static ProjectTargetPlatform SqlMI { get; } = new ProjectTargetPlatform(SqlMIValue);
        /// <summary> AzureDbForMySql. </summary>
        public static ProjectTargetPlatform AzureDBForMySql { get; } = new ProjectTargetPlatform(AzureDBForMySqlValue);
        /// <summary> AzureDbForPostgreSql. </summary>
        public static ProjectTargetPlatform AzureDBForPostgreSql { get; } = new ProjectTargetPlatform(AzureDBForPostgreSqlValue);
        /// <summary> MongoDb. </summary>
        public static ProjectTargetPlatform MongoDB { get; } = new ProjectTargetPlatform(MongoDBValue);
        /// <summary> Unknown. </summary>
        public static ProjectTargetPlatform Unknown { get; } = new ProjectTargetPlatform(UnknownValue);
        /// <summary> Determines if two <see cref="ProjectTargetPlatform"/> values are the same. </summary>
        public static bool operator ==(ProjectTargetPlatform left, ProjectTargetPlatform right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ProjectTargetPlatform"/> values are not the same. </summary>
        public static bool operator !=(ProjectTargetPlatform left, ProjectTargetPlatform right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ProjectTargetPlatform"/>. </summary>
        public static implicit operator ProjectTargetPlatform(string value) => new ProjectTargetPlatform(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ProjectTargetPlatform other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ProjectTargetPlatform other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
