// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Source platform of the project. </summary>
    public readonly partial struct ProjectSourcePlatform : IEquatable<ProjectSourcePlatform>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ProjectSourcePlatform"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ProjectSourcePlatform(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SqlValue = "SQL";
        private const string MySqlValue = "MySQL";
        private const string PostgreSqlValue = "PostgreSql";
        private const string MongoDBValue = "MongoDb";
        private const string UnknownValue = "Unknown";

        /// <summary> SQL. </summary>
        public static ProjectSourcePlatform Sql { get; } = new ProjectSourcePlatform(SqlValue);
        /// <summary> MySQL. </summary>
        public static ProjectSourcePlatform MySql { get; } = new ProjectSourcePlatform(MySqlValue);
        /// <summary> PostgreSql. </summary>
        public static ProjectSourcePlatform PostgreSql { get; } = new ProjectSourcePlatform(PostgreSqlValue);
        /// <summary> MongoDb. </summary>
        public static ProjectSourcePlatform MongoDB { get; } = new ProjectSourcePlatform(MongoDBValue);
        /// <summary> Unknown. </summary>
        public static ProjectSourcePlatform Unknown { get; } = new ProjectSourcePlatform(UnknownValue);
        /// <summary> Determines if two <see cref="ProjectSourcePlatform"/> values are the same. </summary>
        public static bool operator ==(ProjectSourcePlatform left, ProjectSourcePlatform right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ProjectSourcePlatform"/> values are not the same. </summary>
        public static bool operator !=(ProjectSourcePlatform left, ProjectSourcePlatform right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ProjectSourcePlatform"/>. </summary>
        public static implicit operator ProjectSourcePlatform(string value) => new ProjectSourcePlatform(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ProjectSourcePlatform other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ProjectSourcePlatform other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
