// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Base class for file properties. </summary>
    public partial class ProjectFileProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ProjectFileProperties"/>. </summary>
        public ProjectFileProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ProjectFileProperties"/>. </summary>
        /// <param name="extension"> Optional File extension. If submitted it should not have a leading period and must match the extension from filePath. </param>
        /// <param name="filePath"> Relative path of this file resource. This property can be set when creating or updating the file resource. </param>
        /// <param name="lastModified"> Modification DateTime. </param>
        /// <param name="mediaType"> File content type. This property can be modified to reflect the file content type. </param>
        /// <param name="size"> File size. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ProjectFileProperties(string extension, string filePath, DateTimeOffset? lastModified, string mediaType, long? size, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Extension = extension;
            FilePath = filePath;
            LastModified = lastModified;
            MediaType = mediaType;
            Size = size;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Optional File extension. If submitted it should not have a leading period and must match the extension from filePath. </summary>
        public string Extension { get; set; }
        /// <summary> Relative path of this file resource. This property can be set when creating or updating the file resource. </summary>
        public string FilePath { get; set; }
        /// <summary> Modification DateTime. </summary>
        public DateTimeOffset? LastModified { get; }
        /// <summary> File content type. This property can be modified to reflect the file content type. </summary>
        public string MediaType { get; set; }
        /// <summary> File size. </summary>
        public long? Size { get; }
    }
}
