// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Information for connecting to Oracle server. </summary>
    public partial class OracleConnectionInfo : ConnectionInfo
    {
        /// <summary> Initializes a new instance of <see cref="OracleConnectionInfo"/>. </summary>
        /// <param name="dataSource"> EZConnect or TNSName connection string. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="dataSource"/> is null. </exception>
        public OracleConnectionInfo(string dataSource)
        {
            Argument.AssertNotNull(dataSource, nameof(dataSource));

            DataSource = dataSource;
            ConnectionInfoType = "OracleConnectionInfo";
        }

        /// <summary> Initializes a new instance of <see cref="OracleConnectionInfo"/>. </summary>
        /// <param name="connectionInfoType"> Type of connection info. </param>
        /// <param name="userName"> User name. </param>
        /// <param name="password"> Password credential. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="dataSource"> EZConnect or TNSName connection string. </param>
        /// <param name="serverName"> name of the server. </param>
        /// <param name="serverVersion"> server version. </param>
        /// <param name="port"> port for server. </param>
        /// <param name="authentication"> Authentication type to use for connection. </param>
        internal OracleConnectionInfo(string connectionInfoType, string userName, string password, IDictionary<string, BinaryData> serializedAdditionalRawData, string dataSource, string serverName, string serverVersion, int? port, AuthenticationType? authentication) : base(connectionInfoType, userName, password, serializedAdditionalRawData)
        {
            DataSource = dataSource;
            ServerName = serverName;
            ServerVersion = serverVersion;
            Port = port;
            Authentication = authentication;
            ConnectionInfoType = connectionInfoType ?? "OracleConnectionInfo";
        }

        /// <summary> Initializes a new instance of <see cref="OracleConnectionInfo"/> for deserialization. </summary>
        internal OracleConnectionInfo()
        {
        }

        /// <summary> EZConnect or TNSName connection string. </summary>
        public string DataSource { get; set; }
        /// <summary> name of the server. </summary>
        public string ServerName { get; set; }
        /// <summary> server version. </summary>
        public string ServerVersion { get; set; }
        /// <summary> port for server. </summary>
        public int? Port { get; set; }
        /// <summary> Authentication type to use for connection. </summary>
        public AuthenticationType? Authentication { get; set; }
    }
}
