// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> An enumeration of type of objects. </summary>
    public readonly partial struct ObjectType : IEquatable<ObjectType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ObjectType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ObjectType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StoredProceduresValue = "StoredProcedures";
        private const string TableValue = "Table";
        private const string UserValue = "User";
        private const string ViewValue = "View";
        private const string FunctionValue = "Function";

        /// <summary> StoredProcedures. </summary>
        public static ObjectType StoredProcedures { get; } = new ObjectType(StoredProceduresValue);
        /// <summary> Table. </summary>
        public static ObjectType Table { get; } = new ObjectType(TableValue);
        /// <summary> User. </summary>
        public static ObjectType User { get; } = new ObjectType(UserValue);
        /// <summary> View. </summary>
        public static ObjectType View { get; } = new ObjectType(ViewValue);
        /// <summary> Function. </summary>
        public static ObjectType Function { get; } = new ObjectType(FunctionValue);
        /// <summary> Determines if two <see cref="ObjectType"/> values are the same. </summary>
        public static bool operator ==(ObjectType left, ObjectType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ObjectType"/> values are not the same. </summary>
        public static bool operator !=(ObjectType left, ObjectType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ObjectType"/>. </summary>
        public static implicit operator ObjectType(string value) => new ObjectType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ObjectType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ObjectType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
