// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> An enumeration of possible target types when migrating from MySQL. </summary>
    public readonly partial struct MySqlTargetPlatformType : IEquatable<MySqlTargetPlatformType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MySqlTargetPlatformType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MySqlTargetPlatformType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SqlServerValue = "SqlServer";
        private const string AzureDBForMySqlValue = "AzureDbForMySQL";

        /// <summary> SqlServer. </summary>
        public static MySqlTargetPlatformType SqlServer { get; } = new MySqlTargetPlatformType(SqlServerValue);
        /// <summary> AzureDbForMySQL. </summary>
        public static MySqlTargetPlatformType AzureDBForMySql { get; } = new MySqlTargetPlatformType(AzureDBForMySqlValue);
        /// <summary> Determines if two <see cref="MySqlTargetPlatformType"/> values are the same. </summary>
        public static bool operator ==(MySqlTargetPlatformType left, MySqlTargetPlatformType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MySqlTargetPlatformType"/> values are not the same. </summary>
        public static bool operator !=(MySqlTargetPlatformType left, MySqlTargetPlatformType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MySqlTargetPlatformType"/>. </summary>
        public static implicit operator MySqlTargetPlatformType(string value) => new MySqlTargetPlatformType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MySqlTargetPlatformType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MySqlTargetPlatformType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
