// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> The field ordering. </summary>
    public readonly partial struct MongoDBShardKeyOrder : IEquatable<MongoDBShardKeyOrder>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MongoDBShardKeyOrder"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MongoDBShardKeyOrder(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ForwardValue = "Forward";
        private const string ReverseValue = "Reverse";
        private const string HashedValue = "Hashed";

        /// <summary> Forward. </summary>
        public static MongoDBShardKeyOrder Forward { get; } = new MongoDBShardKeyOrder(ForwardValue);
        /// <summary> Reverse. </summary>
        public static MongoDBShardKeyOrder Reverse { get; } = new MongoDBShardKeyOrder(ReverseValue);
        /// <summary> Hashed. </summary>
        public static MongoDBShardKeyOrder Hashed { get; } = new MongoDBShardKeyOrder(HashedValue);
        /// <summary> Determines if two <see cref="MongoDBShardKeyOrder"/> values are the same. </summary>
        public static bool operator ==(MongoDBShardKeyOrder left, MongoDBShardKeyOrder right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MongoDBShardKeyOrder"/> values are not the same. </summary>
        public static bool operator !=(MongoDBShardKeyOrder left, MongoDBShardKeyOrder right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MongoDBShardKeyOrder"/>. </summary>
        public static implicit operator MongoDBShardKeyOrder(string value) => new MongoDBShardKeyOrder(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MongoDBShardKeyOrder other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MongoDBShardKeyOrder other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
