// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Describes how changes will be replicated from the source to the target. The default is OneTime. </summary>
    public readonly partial struct MongoDBReplication : IEquatable<MongoDBReplication>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MongoDBReplication"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MongoDBReplication(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DisabledValue = "Disabled";
        private const string OneTimeValue = "OneTime";
        private const string ContinuousValue = "Continuous";

        /// <summary> Disabled. </summary>
        public static MongoDBReplication Disabled { get; } = new MongoDBReplication(DisabledValue);
        /// <summary> OneTime. </summary>
        public static MongoDBReplication OneTime { get; } = new MongoDBReplication(OneTimeValue);
        /// <summary> Continuous. </summary>
        public static MongoDBReplication Continuous { get; } = new MongoDBReplication(ContinuousValue);
        /// <summary> Determines if two <see cref="MongoDBReplication"/> values are the same. </summary>
        public static bool operator ==(MongoDBReplication left, MongoDBReplication right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MongoDBReplication"/> values are not the same. </summary>
        public static bool operator !=(MongoDBReplication left, MongoDBReplication right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MongoDBReplication"/>. </summary>
        public static implicit operator MongoDBReplication(string value) => new MongoDBReplication(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MongoDBReplication other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MongoDBReplication other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
