// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary>
    /// Base class for MongoDB migration outputs
    /// Please note <see cref="MongoDBProgress"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
    /// The available derived classes include <see cref="MongoDBCollectionProgress"/>, <see cref="MongoDBDatabaseProgress"/> and <see cref="MongoDBMigrationProgress"/>.
    /// </summary>
    public abstract partial class MongoDBProgress
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private protected IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MongoDBProgress"/>. </summary>
        /// <param name="bytesCopied"> The number of document bytes copied during the Copying stage. </param>
        /// <param name="documentsCopied"> The number of documents copied during the Copying stage. </param>
        /// <param name="elapsedTime"> The elapsed time in the format [ddd.]hh:mm:ss[.fffffff] (i.e. TimeSpan format). </param>
        /// <param name="errors"> The errors and warnings that have occurred for the current object. The keys are the error codes. </param>
        /// <param name="eventsPending"> The number of oplog events awaiting replay. </param>
        /// <param name="eventsReplayed"> The number of oplog events replayed so far. </param>
        /// <param name="state"></param>
        /// <param name="totalBytes"> The total number of document bytes on the source at the beginning of the Copying stage, or -1 if the total size was unknown. </param>
        /// <param name="totalDocuments"> The total number of documents on the source at the beginning of the Copying stage, or -1 if the total count was unknown. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="elapsedTime"/> or <paramref name="errors"/> is null. </exception>
        protected MongoDBProgress(long bytesCopied, long documentsCopied, string elapsedTime, IReadOnlyDictionary<string, MongoDBError> errors, long eventsPending, long eventsReplayed, MongoDBMigrationState state, long totalBytes, long totalDocuments)
        {
            Argument.AssertNotNull(elapsedTime, nameof(elapsedTime));
            Argument.AssertNotNull(errors, nameof(errors));

            BytesCopied = bytesCopied;
            DocumentsCopied = documentsCopied;
            ElapsedTime = elapsedTime;
            Errors = errors;
            EventsPending = eventsPending;
            EventsReplayed = eventsReplayed;
            State = state;
            TotalBytes = totalBytes;
            TotalDocuments = totalDocuments;
        }

        /// <summary> Initializes a new instance of <see cref="MongoDBProgress"/>. </summary>
        /// <param name="bytesCopied"> The number of document bytes copied during the Copying stage. </param>
        /// <param name="documentsCopied"> The number of documents copied during the Copying stage. </param>
        /// <param name="elapsedTime"> The elapsed time in the format [ddd.]hh:mm:ss[.fffffff] (i.e. TimeSpan format). </param>
        /// <param name="errors"> The errors and warnings that have occurred for the current object. The keys are the error codes. </param>
        /// <param name="eventsPending"> The number of oplog events awaiting replay. </param>
        /// <param name="eventsReplayed"> The number of oplog events replayed so far. </param>
        /// <param name="lastEventOn"> The timestamp of the last oplog event received, or null if no oplog event has been received yet. </param>
        /// <param name="lastReplayOn"> The timestamp of the last oplog event replayed, or null if no oplog event has been replayed yet. </param>
        /// <param name="name"> The name of the progress object. For a collection, this is the unqualified collection name. For a database, this is the database name. For the overall migration, this is null. </param>
        /// <param name="qualifiedName"> The qualified name of the progress object. For a collection, this is the database-qualified name. For a database, this is the database name. For the overall migration, this is null. </param>
        /// <param name="resultType"> The type of progress object. </param>
        /// <param name="state"></param>
        /// <param name="totalBytes"> The total number of document bytes on the source at the beginning of the Copying stage, or -1 if the total size was unknown. </param>
        /// <param name="totalDocuments"> The total number of documents on the source at the beginning of the Copying stage, or -1 if the total count was unknown. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MongoDBProgress(long bytesCopied, long documentsCopied, string elapsedTime, IReadOnlyDictionary<string, MongoDBError> errors, long eventsPending, long eventsReplayed, DateTimeOffset? lastEventOn, DateTimeOffset? lastReplayOn, string name, string qualifiedName, MongoDBProgressResultType resultType, MongoDBMigrationState state, long totalBytes, long totalDocuments, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            BytesCopied = bytesCopied;
            DocumentsCopied = documentsCopied;
            ElapsedTime = elapsedTime;
            Errors = errors;
            EventsPending = eventsPending;
            EventsReplayed = eventsReplayed;
            LastEventOn = lastEventOn;
            LastReplayOn = lastReplayOn;
            Name = name;
            QualifiedName = qualifiedName;
            ResultType = resultType;
            State = state;
            TotalBytes = totalBytes;
            TotalDocuments = totalDocuments;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MongoDBProgress"/> for deserialization. </summary>
        internal MongoDBProgress()
        {
        }

        /// <summary> The number of document bytes copied during the Copying stage. </summary>
        public long BytesCopied { get; }
        /// <summary> The number of documents copied during the Copying stage. </summary>
        public long DocumentsCopied { get; }
        /// <summary> The elapsed time in the format [ddd.]hh:mm:ss[.fffffff] (i.e. TimeSpan format). </summary>
        public string ElapsedTime { get; }
        /// <summary> The errors and warnings that have occurred for the current object. The keys are the error codes. </summary>
        public IReadOnlyDictionary<string, MongoDBError> Errors { get; }
        /// <summary> The number of oplog events awaiting replay. </summary>
        public long EventsPending { get; }
        /// <summary> The number of oplog events replayed so far. </summary>
        public long EventsReplayed { get; }
        /// <summary> The timestamp of the last oplog event received, or null if no oplog event has been received yet. </summary>
        public DateTimeOffset? LastEventOn { get; }
        /// <summary> The timestamp of the last oplog event replayed, or null if no oplog event has been replayed yet. </summary>
        public DateTimeOffset? LastReplayOn { get; }
        /// <summary> The name of the progress object. For a collection, this is the unqualified collection name. For a database, this is the database name. For the overall migration, this is null. </summary>
        public string Name { get; }
        /// <summary> The qualified name of the progress object. For a collection, this is the database-qualified name. For a database, this is the database name. For the overall migration, this is null. </summary>
        public string QualifiedName { get; }
        /// <summary> The type of progress object. </summary>
        internal MongoDBProgressResultType ResultType { get; set; }
        /// <summary> Gets the state. </summary>
        public MongoDBMigrationState State { get; }
        /// <summary> The total number of document bytes on the source at the beginning of the Copying stage, or -1 if the total size was unknown. </summary>
        public long TotalBytes { get; }
        /// <summary> The total number of documents on the source at the beginning of the Copying stage, or -1 if the total count was unknown. </summary>
        public long TotalDocuments { get; }
    }
}
