// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.DataMigration.Models
{
    [PersistableModelProxy(typeof(UnknownMongoDBProgress))]
    public partial class MongoDBProgress : IUtf8JsonSerializable, IJsonModel<MongoDBProgress>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<MongoDBProgress>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<MongoDBProgress>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MongoDBProgress>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MongoDBProgress)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("bytesCopied"u8);
            writer.WriteNumberValue(BytesCopied);
            writer.WritePropertyName("documentsCopied"u8);
            writer.WriteNumberValue(DocumentsCopied);
            writer.WritePropertyName("elapsedTime"u8);
            writer.WriteStringValue(ElapsedTime);
            writer.WritePropertyName("errors"u8);
            writer.WriteStartObject();
            foreach (var item in Errors)
            {
                writer.WritePropertyName(item.Key);
                writer.WriteObjectValue(item.Value, options);
            }
            writer.WriteEndObject();
            writer.WritePropertyName("eventsPending"u8);
            writer.WriteNumberValue(EventsPending);
            writer.WritePropertyName("eventsReplayed"u8);
            writer.WriteNumberValue(EventsReplayed);
            if (Optional.IsDefined(LastEventOn))
            {
                writer.WritePropertyName("lastEventTime"u8);
                writer.WriteStringValue(LastEventOn.Value, "O");
            }
            if (Optional.IsDefined(LastReplayOn))
            {
                writer.WritePropertyName("lastReplayTime"u8);
                writer.WriteStringValue(LastReplayOn.Value, "O");
            }
            if (Optional.IsDefined(Name))
            {
                writer.WritePropertyName("name"u8);
                writer.WriteStringValue(Name);
            }
            if (Optional.IsDefined(QualifiedName))
            {
                writer.WritePropertyName("qualifiedName"u8);
                writer.WriteStringValue(QualifiedName);
            }
            writer.WritePropertyName("resultType"u8);
            writer.WriteStringValue(ResultType.ToString());
            writer.WritePropertyName("state"u8);
            writer.WriteStringValue(State.ToString());
            writer.WritePropertyName("totalBytes"u8);
            writer.WriteNumberValue(TotalBytes);
            writer.WritePropertyName("totalDocuments"u8);
            writer.WriteNumberValue(TotalDocuments);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        MongoDBProgress IJsonModel<MongoDBProgress>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MongoDBProgress>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(MongoDBProgress)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeMongoDBProgress(document.RootElement, options);
        }

        internal static MongoDBProgress DeserializeMongoDBProgress(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            if (element.TryGetProperty("resultType", out JsonElement discriminator))
            {
                switch (discriminator.GetString())
                {
                    case "Collection": return MongoDBCollectionProgress.DeserializeMongoDBCollectionProgress(element, options);
                    case "Database": return MongoDBDatabaseProgress.DeserializeMongoDBDatabaseProgress(element, options);
                    case "Migration": return MongoDBMigrationProgress.DeserializeMongoDBMigrationProgress(element, options);
                }
            }
            return UnknownMongoDBProgress.DeserializeUnknownMongoDBProgress(element, options);
        }

        BinaryData IPersistableModel<MongoDBProgress>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MongoDBProgress>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(MongoDBProgress)} does not support writing '{options.Format}' format.");
            }
        }

        MongoDBProgress IPersistableModel<MongoDBProgress>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<MongoDBProgress>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeMongoDBProgress(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(MongoDBProgress)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<MongoDBProgress>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
