// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Describes how an individual MongoDB database should be migrated. </summary>
    public partial class MongoDBDatabaseSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MongoDBDatabaseSettings"/>. </summary>
        /// <param name="collections"> The collections on the source database to migrate to the target. The keys are the unqualified names of the collections. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="collections"/> is null. </exception>
        public MongoDBDatabaseSettings(IDictionary<string, MongoDBCollectionSettings> collections)
        {
            Argument.AssertNotNull(collections, nameof(collections));

            Collections = collections;
        }

        /// <summary> Initializes a new instance of <see cref="MongoDBDatabaseSettings"/>. </summary>
        /// <param name="collections"> The collections on the source database to migrate to the target. The keys are the unqualified names of the collections. </param>
        /// <param name="targetRUs"> The RUs that should be configured on a CosmosDB target, or null to use the default, or 0 if throughput should not be provisioned for the database. This has no effect on non-CosmosDB targets. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MongoDBDatabaseSettings(IDictionary<string, MongoDBCollectionSettings> collections, int? targetRUs, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Collections = collections;
            TargetRUs = targetRUs;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MongoDBDatabaseSettings"/> for deserialization. </summary>
        internal MongoDBDatabaseSettings()
        {
        }

        /// <summary> The collections on the source database to migrate to the target. The keys are the unqualified names of the collections. </summary>
        public IDictionary<string, MongoDBCollectionSettings> Collections { get; }
        /// <summary> The RUs that should be configured on a CosmosDB target, or null to use the default, or 0 if throughput should not be provisioned for the database. This has no effect on non-CosmosDB targets. </summary>
        public int? TargetRUs { get; set; }
    }
}
