// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Types of validations to run after the migration. </summary>
    public partial class MigrationValidationOptions
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MigrationValidationOptions"/>. </summary>
        public MigrationValidationOptions()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MigrationValidationOptions"/>. </summary>
        /// <param name="enableSchemaValidation"> Allows to compare the schema information between source and target. </param>
        /// <param name="enableDataIntegrityValidation"> Allows to perform a checksum based data integrity validation between source and target for the selected database / tables . </param>
        /// <param name="enableQueryAnalysisValidation"> Allows to perform a quick and intelligent query analysis by retrieving queries from the source database and executes them in the target. The result will have execution statistics for executions in source and target databases for the extracted queries. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MigrationValidationOptions(bool? enableSchemaValidation, bool? enableDataIntegrityValidation, bool? enableQueryAnalysisValidation, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            EnableSchemaValidation = enableSchemaValidation;
            EnableDataIntegrityValidation = enableDataIntegrityValidation;
            EnableQueryAnalysisValidation = enableQueryAnalysisValidation;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Allows to compare the schema information between source and target. </summary>
        public bool? EnableSchemaValidation { get; set; }
        /// <summary> Allows to perform a checksum based data integrity validation between source and target for the selected database / tables . </summary>
        public bool? EnableDataIntegrityValidation { get; set; }
        /// <summary> Allows to perform a quick and intelligent query analysis by retrieving queries from the source database and executes them in the target. The result will have execution statistics for executions in source and target databases for the extracted queries. </summary>
        public bool? EnableQueryAnalysisValidation { get; set; }
    }
}
