// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Current status of migration. </summary>
    public readonly partial struct MigrationStatus : IEquatable<MigrationStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MigrationStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MigrationStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DefaultValue = "Default";
        private const string ConnectingValue = "Connecting";
        private const string SourceAndTargetSelectedValue = "SourceAndTargetSelected";
        private const string SelectLoginsValue = "SelectLogins";
        private const string ConfiguredValue = "Configured";
        private const string RunningValue = "Running";
        private const string ErrorValue = "Error";
        private const string StoppedValue = "Stopped";
        private const string CompletedValue = "Completed";
        private const string CompletedWithWarningsValue = "CompletedWithWarnings";

        /// <summary> Default. </summary>
        public static MigrationStatus Default { get; } = new MigrationStatus(DefaultValue);
        /// <summary> Connecting. </summary>
        public static MigrationStatus Connecting { get; } = new MigrationStatus(ConnectingValue);
        /// <summary> SourceAndTargetSelected. </summary>
        public static MigrationStatus SourceAndTargetSelected { get; } = new MigrationStatus(SourceAndTargetSelectedValue);
        /// <summary> SelectLogins. </summary>
        public static MigrationStatus SelectLogins { get; } = new MigrationStatus(SelectLoginsValue);
        /// <summary> Configured. </summary>
        public static MigrationStatus Configured { get; } = new MigrationStatus(ConfiguredValue);
        /// <summary> Running. </summary>
        public static MigrationStatus Running { get; } = new MigrationStatus(RunningValue);
        /// <summary> Error. </summary>
        public static MigrationStatus Error { get; } = new MigrationStatus(ErrorValue);
        /// <summary> Stopped. </summary>
        public static MigrationStatus Stopped { get; } = new MigrationStatus(StoppedValue);
        /// <summary> Completed. </summary>
        public static MigrationStatus Completed { get; } = new MigrationStatus(CompletedValue);
        /// <summary> CompletedWithWarnings. </summary>
        public static MigrationStatus CompletedWithWarnings { get; } = new MigrationStatus(CompletedWithWarningsValue);
        /// <summary> Determines if two <see cref="MigrationStatus"/> values are the same. </summary>
        public static bool operator ==(MigrationStatus left, MigrationStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MigrationStatus"/> values are not the same. </summary>
        public static bool operator !=(MigrationStatus left, MigrationStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MigrationStatus"/>. </summary>
        public static implicit operator MigrationStatus(string value) => new MigrationStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MigrationStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MigrationStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
